/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.page;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.UUID;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.HasUUID;
import org.thingsboard.server.common.data.page.TimePageLink;

public class TimePageData<T extends HasId<? extends HasUUID>> {
    private final List<T> data;
    private final TimePageLink nextPageLink;
    private final boolean hasNext;

    public TimePageData(List<? extends HasUUID> ids, List<T> data, TimePageLink pageLink) {
        this.data = data;
        int limit = pageLink.getLimit();
        if (ids != null && ids.size() == limit) {
            int index = ids.size() - 1;
            UUID idOffset = ids.get(index).getId();
            this.nextPageLink = new TimePageLink(limit, pageLink.getStartTime(), pageLink.getEndTime(), pageLink.isAscOrder(), idOffset);
            this.hasNext = true;
        } else {
            this.nextPageLink = null;
            this.hasNext = false;
        }
    }

    public TimePageData(List<T> data, TimePageLink pageLink) {
        this.data = data;
        int limit = pageLink.getLimit();
        if (data != null && data.size() == limit) {
            int index = data.size() - 1;
            UUID idOffset = ((HasId)data.get(index)).getId().getId();
            this.nextPageLink = new TimePageLink(limit, pageLink.getStartTime(), pageLink.getEndTime(), pageLink.isAscOrder(), idOffset);
            this.hasNext = true;
        } else {
            this.nextPageLink = null;
            this.hasNext = false;
        }
    }

    @JsonCreator
    public TimePageData(@JsonProperty(value="data") List<T> data, @JsonProperty(value="nextPageLink") TimePageLink nextPageLink, @JsonProperty(value="hasNext") boolean hasNext) {
        this.data = data;
        this.nextPageLink = nextPageLink;
        this.hasNext = hasNext;
    }

    public List<T> getData() {
        return this.data;
    }

    @JsonProperty(value="hasNext")
    public boolean hasNext() {
        return this.hasNext;
    }

    public TimePageLink getNextPageLink() {
        return this.nextPageLink;
    }
}

