/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.page;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.UUID;
import org.thingsboard.server.common.data.page.BasePageLink;

public class TextPageLink
extends BasePageLink
implements Serializable {
    private static final long serialVersionUID = -4189954843653250480L;
    private final String textSearch;
    private final String textSearchBound;
    private final String textOffset;

    public TextPageLink(int limit) {
        this(limit, null, null, null);
    }

    public TextPageLink(int limit, String textSearch) {
        this(limit, textSearch, null, null);
    }

    public TextPageLink(int limit, String textSearch, UUID idOffset, String textOffset) {
        super(limit, idOffset);
        this.textSearch = textSearch != null ? textSearch.toLowerCase() : null;
        this.textSearchBound = TextPageLink.nextSequence(this.textSearch);
        this.textOffset = textOffset != null ? textOffset.toLowerCase() : null;
    }

    @JsonCreator
    public TextPageLink(@JsonProperty(value="limit") int limit, @JsonProperty(value="textSearch") String textSearch, @JsonProperty(value="textSearchBound") String textSearchBound, @JsonProperty(value="textOffset") String textOffset, @JsonProperty(value="idOffset") UUID idOffset) {
        super(limit, idOffset);
        this.textSearch = textSearch;
        this.textSearchBound = textSearchBound;
        this.textOffset = textOffset;
        this.idOffset = idOffset;
    }

    private static String nextSequence(String input) {
        if (input != null && input.length() > 0) {
            char[] chars = input.toCharArray();
            int i = chars.length - 1;
            while (i >= 0) {
                int n = i--;
                chars[n] = (char)(chars[n] + '\u0001');
                if (chars[n] == '\u0000') continue;
            }
            if (i == -1 && (chars.length == 0 || chars[0] == '\u0000')) {
                char[] buf = Arrays.copyOf(input.toCharArray(), input.length() + 1);
                buf[buf.length - 1] = '\u0000';
                return new String(buf);
            }
            return new String(chars);
        }
        return null;
    }

    public String toString() {
        return "TextPageLink(textSearch=" + this.getTextSearch() + ", textSearchBound=" + this.getTextSearchBound() + ", textOffset=" + this.getTextOffset() + ")";
    }

    public String getTextSearch() {
        return this.textSearch;
    }

    public String getTextSearchBound() {
        return this.textSearchBound;
    }

    public String getTextOffset() {
        return this.textOffset;
    }
}

