/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.page;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.UUID;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.TextPageLink;

public class TextPageData<T extends SearchTextBased<? extends UUIDBased>> {
    private final List<T> data;
    private final TextPageLink nextPageLink;
    private final boolean hasNext;

    public TextPageData(List<T> data, TextPageLink pageLink) {
        this.data = data;
        int limit = pageLink.getLimit();
        if (data != null && data.size() == limit) {
            int index = data.size() - 1;
            UUID idOffset = ((UUIDBased)((SearchTextBased)data.get(index)).getId()).getId();
            String textOffset = ((SearchTextBased)data.get(index)).getSearchText();
            this.nextPageLink = new TextPageLink(limit, pageLink.getTextSearch(), idOffset, textOffset);
            this.hasNext = true;
        } else {
            this.nextPageLink = null;
            this.hasNext = false;
        }
    }

    @JsonCreator
    public TextPageData(@JsonProperty(value="data") List<T> data, @JsonProperty(value="nextPageLink") TextPageLink nextPageLink, @JsonProperty(value="hasNext") boolean hasNext) {
        this.data = data;
        this.nextPageLink = nextPageLink;
        this.hasNext = hasNext;
    }

    public List<T> getData() {
        return this.data;
    }

    @JsonProperty(value="hasNext")
    public boolean hasNext() {
        return this.hasNext;
    }

    public TextPageLink getNextPageLink() {
        return this.nextPageLink;
    }
}

