/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.page;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.TextPageData;
import org.thingsboard.server.common.data.page.TextPageLink;

public class PageDataIterable<T extends SearchTextBased<? extends UUIDBased>>
implements Iterable<T>,
Iterator<T> {
    private final FetchFunction<T> function;
    private final int fetchSize;
    private List<T> currentItems;
    private int currentIdx;
    private boolean hasNextPack;
    private TextPageLink nextPackLink;
    private boolean initialized;

    public PageDataIterable(FetchFunction<T> function, int fetchSize) {
        this.function = function;
        this.fetchSize = fetchSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.fetch(new TextPageLink(this.fetchSize));
            this.initialized = true;
        }
        if (this.currentIdx == this.currentItems.size() && this.hasNextPack) {
            this.fetch(this.nextPackLink);
        }
        return this.currentIdx < this.currentItems.size();
    }

    private void fetch(TextPageLink link) {
        TextPageData<T> pageData = this.function.fetch(link);
        this.currentIdx = 0;
        this.currentItems = pageData.getData();
        this.hasNextPack = pageData.hasNext();
        this.nextPackLink = pageData.getNextPageLink();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (T)((SearchTextBased)this.currentItems.get(this.currentIdx++));
    }

    public static interface FetchFunction<T extends SearchTextBased<? extends UUIDBased>> {
        public TextPageData<T> fetch(TextPageLink var1);
    }
}

