/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.kv;

import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.BaseTsKvQuery;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;

public class BaseReadTsKvQuery
extends BaseTsKvQuery
implements ReadTsKvQuery {
    private final long interval;
    private final int limit;
    private final Aggregation aggregation;
    private final String orderBy;

    public BaseReadTsKvQuery(String key, long startTs, long endTs, long interval, int limit, Aggregation aggregation) {
        this(key, startTs, endTs, interval, limit, aggregation, "DESC");
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs, long interval, int limit, Aggregation aggregation, String orderBy) {
        super(key, startTs, endTs);
        this.interval = interval;
        this.limit = limit;
        this.aggregation = aggregation;
        this.orderBy = orderBy;
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs) {
        this(key, startTs, endTs, endTs - startTs, 1, Aggregation.AVG, "DESC");
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs, int limit, String orderBy) {
        this(key, startTs, endTs, endTs - startTs, limit, Aggregation.NONE, orderBy);
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public Aggregation getAggregation() {
        return this.aggregation;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseReadTsKvQuery)) {
            return false;
        }
        BaseReadTsKvQuery other = (BaseReadTsKvQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInterval() != other.getInterval()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        Aggregation this$aggregation = this.getAggregation();
        Aggregation other$aggregation = other.getAggregation();
        if (this$aggregation == null ? other$aggregation != null : !((Object)((Object)this$aggregation)).equals((Object)other$aggregation)) {
            return false;
        }
        String this$orderBy = this.getOrderBy();
        String other$orderBy = other.getOrderBy();
        return !(this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseReadTsKvQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $interval = this.getInterval();
        result = result * 59 + (int)($interval >>> 32 ^ $interval);
        result = result * 59 + this.getLimit();
        Aggregation $aggregation = this.getAggregation();
        result = result * 59 + ($aggregation == null ? 43 : ((Object)((Object)$aggregation)).hashCode());
        String $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BaseReadTsKvQuery(interval=" + this.getInterval() + ", limit=" + this.getLimit() + ", aggregation=" + (Object)((Object)this.getAggregation()) + ", orderBy=" + this.getOrderBy() + ")";
    }
}

