/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.integration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.IntegrationType;

public class Integration
extends SearchTextBased<IntegrationId>
implements HasName,
TenantEntity {
    private static final long serialVersionUID = 4934987577236873728L;
    private TenantId tenantId;
    private ConverterId defaultConverterId;
    private ConverterId downlinkConverterId;
    private String name;
    private String routingKey;
    private IntegrationType type;
    private boolean debugMode;
    private Boolean enabled;
    private Boolean isRemote;
    private String secret;
    private transient JsonNode configuration;
    private transient JsonNode additionalInfo;

    public Integration() {
    }

    public Integration(IntegrationId id) {
        super(id);
    }

    public Integration(Integration integration) {
        super(integration);
        this.tenantId = integration.getTenantId();
        this.defaultConverterId = integration.getDefaultConverterId();
        this.downlinkConverterId = integration.getDownlinkConverterId();
        this.name = integration.getName();
        this.routingKey = integration.getRoutingKey();
        this.type = integration.getType();
        this.debugMode = integration.isDebugMode();
        this.enabled = integration.isEnabled();
        this.isRemote = integration.isRemote();
        this.secret = integration.getSecret();
        this.configuration = integration.getConfiguration();
        this.additionalInfo = integration.getAdditionalInfo();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public ConverterId getDefaultConverterId() {
        return this.defaultConverterId;
    }

    public void setDefaultConverterId(ConverterId defaultConverterId) {
        this.defaultConverterId = defaultConverterId;
    }

    public ConverterId getDownlinkConverterId() {
        return this.downlinkConverterId;
    }

    public void setDownlinkConverterId(ConverterId downlinkConverterId) {
        this.downlinkConverterId = downlinkConverterId;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public IntegrationType getType() {
        return this.type;
    }

    public void setType(IntegrationType type) {
        this.type = type;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public Boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean isRemote() {
        return this.isRemote != null && this.isRemote != false;
    }

    public void setRemote(Boolean remote) {
        this.isRemote = remote;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    public JsonNode getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(JsonNode additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Integration [tenantId=");
        builder.append(this.tenantId);
        builder.append(", defaultConverterId=");
        builder.append(this.defaultConverterId);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", routingKey=");
        builder.append(this.routingKey);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", debugMode=");
        builder.append(this.debugMode);
        builder.append(", isRemote=");
        builder.append(this.isRemote);
        builder.append(", secret=");
        builder.append(this.secret);
        builder.append(", configuration=");
        builder.append(this.configuration);
        builder.append(", additionalInfo=");
        builder.append(this.additionalInfo);
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.INTEGRATION;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Integration)) {
            return false;
        }
        Integration other = (Integration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        ConverterId this$defaultConverterId = this.getDefaultConverterId();
        ConverterId other$defaultConverterId = other.getDefaultConverterId();
        if (this$defaultConverterId == null ? other$defaultConverterId != null : !((Object)this$defaultConverterId).equals(other$defaultConverterId)) {
            return false;
        }
        ConverterId this$downlinkConverterId = this.getDownlinkConverterId();
        ConverterId other$downlinkConverterId = other.getDownlinkConverterId();
        if (this$downlinkConverterId == null ? other$downlinkConverterId != null : !((Object)this$downlinkConverterId).equals(other$downlinkConverterId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        IntegrationType this$type = this.getType();
        IntegrationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        Boolean this$enabled = this.enabled;
        Boolean other$enabled = other.enabled;
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$isRemote = this.isRemote;
        Boolean other$isRemote = other.isRemote;
        if (this$isRemote == null ? other$isRemote != null : !((Object)this$isRemote).equals(other$isRemote)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Integration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        ConverterId $defaultConverterId = this.getDefaultConverterId();
        result = result * 59 + ($defaultConverterId == null ? 43 : ((Object)$defaultConverterId).hashCode());
        ConverterId $downlinkConverterId = this.getDownlinkConverterId();
        result = result * 59 + ($downlinkConverterId == null ? 43 : ((Object)$downlinkConverterId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        IntegrationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        Boolean $enabled = this.enabled;
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $isRemote = this.isRemote;
        result = result * 59 + ($isRemote == null ? 43 : ((Object)$isRemote).hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        return result;
    }
}

