/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.group;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.group.ColumnConfiguration;
import org.thingsboard.server.common.data.group.ColumnType;
import org.thingsboard.server.common.data.group.EntityField;
import org.thingsboard.server.common.data.group.SortOrder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityGroupConfiguration {
    private List<ColumnConfiguration> columns;

    public List<ColumnConfiguration> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnConfiguration> columns) {
        this.columns = columns;
    }

    public static EntityGroupConfiguration createDefaultEntityGroupConfiguration(EntityType groupType) {
        EntityGroupConfiguration entityGroupConfiguration = new EntityGroupConfiguration();
        ArrayList<ColumnConfiguration> columns = new ArrayList<ColumnConfiguration>();
        EntityField[] entityFields = EntityField.defaultFieldsByEntityType.get((Object)groupType);
        if (entityFields != null) {
            for (EntityField entityField : entityFields) {
                ColumnConfiguration columnConfiguration = new ColumnConfiguration(ColumnType.ENTITY_FIELD, entityField.name().toLowerCase());
                if (entityField == EntityField.CREATED_TIME) {
                    columnConfiguration.setSortOrder(SortOrder.DESC);
                }
                columns.add(columnConfiguration);
            }
        }
        entityGroupConfiguration.setColumns(columns);
        return entityGroupConfiguration;
    }
}

