/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.asset;

import java.util.Collections;
import java.util.List;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.EntityTypeFilter;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;

public class AssetSearchQuery {
    private RelationsSearchParameters parameters;
    private String relationType;
    private List<String> assetTypes;

    public EntityRelationsQuery toEntitySearchQuery() {
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(this.parameters);
        query.setFilters(Collections.singletonList(new EntityTypeFilter(this.relationType == null ? "Contains" : this.relationType, Collections.singletonList(EntityType.ASSET))));
        return query;
    }

    public RelationsSearchParameters getParameters() {
        return this.parameters;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public List<String> getAssetTypes() {
        return this.assetTypes;
    }

    public void setParameters(RelationsSearchParameters parameters) {
        this.parameters = parameters;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public void setAssetTypes(List<String> assetTypes) {
        this.assetTypes = assetTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetSearchQuery)) {
            return false;
        }
        AssetSearchQuery other = (AssetSearchQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationsSearchParameters this$parameters = this.getParameters();
        RelationsSearchParameters other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        if (this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType)) {
            return false;
        }
        List<String> this$assetTypes = this.getAssetTypes();
        List<String> other$assetTypes = other.getAssetTypes();
        return !(this$assetTypes == null ? other$assetTypes != null : !((Object)this$assetTypes).equals(other$assetTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssetSearchQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationsSearchParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        List<String> $assetTypes = this.getAssetTypes();
        result = result * 59 + ($assetTypes == null ? 43 : ((Object)$assetTypes).hashCode());
        return result;
    }

    public String toString() {
        return "AssetSearchQuery(parameters=" + this.getParameters() + ", relationType=" + this.getRelationType() + ", assetTypes=" + this.getAssetTypes() + ")";
    }
}

