/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.alarm.AlarmId;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public class Alarm
extends BaseData<AlarmId>
implements HasName,
TenantEntity {
    private TenantId tenantId;
    private String type;
    private EntityId originator;
    private AlarmSeverity severity;
    private AlarmStatus status;
    private long startTs;
    private long endTs;
    private long ackTs;
    private long clearTs;
    private transient JsonNode details;
    private boolean propagate;

    public Alarm() {
    }

    public Alarm(AlarmId id) {
        super(id);
    }

    public Alarm(Alarm alarm) {
        super(alarm.getId());
        this.createdTime = alarm.getCreatedTime();
        this.tenantId = alarm.getTenantId();
        this.type = alarm.getType();
        this.originator = alarm.getOriginator();
        this.severity = alarm.getSeverity();
        this.status = alarm.getStatus();
        this.startTs = alarm.getStartTs();
        this.endTs = alarm.getEndTs();
        this.ackTs = alarm.getAckTs();
        this.clearTs = alarm.getClearTs();
        this.details = alarm.getDetails();
        this.propagate = alarm.isPropagate();
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.type;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.ALARM;
    }

    public static AlarmBuilder builder() {
        return new AlarmBuilder();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getType() {
        return this.type;
    }

    public EntityId getOriginator() {
        return this.originator;
    }

    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    public AlarmStatus getStatus() {
        return this.status;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public long getAckTs() {
        return this.ackTs;
    }

    public long getClearTs() {
        return this.clearTs;
    }

    public JsonNode getDetails() {
        return this.details;
    }

    public boolean isPropagate() {
        return this.propagate;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setOriginator(EntityId originator) {
        this.originator = originator;
    }

    public void setSeverity(AlarmSeverity severity) {
        this.severity = severity;
    }

    public void setStatus(AlarmStatus status) {
        this.status = status;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setAckTs(long ackTs) {
        this.ackTs = ackTs;
    }

    public void setClearTs(long clearTs) {
        this.clearTs = clearTs;
    }

    public void setDetails(JsonNode details) {
        this.details = details;
    }

    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        EntityId this$originator = this.getOriginator();
        EntityId other$originator = other.getOriginator();
        if (this$originator == null ? other$originator != null : !this$originator.equals(other$originator)) {
            return false;
        }
        AlarmSeverity this$severity = this.getSeverity();
        AlarmSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        AlarmStatus this$status = this.getStatus();
        AlarmStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        if (this.getAckTs() != other.getAckTs()) {
            return false;
        }
        if (this.getClearTs() != other.getClearTs()) {
            return false;
        }
        return this.isPropagate() == other.isPropagate();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Alarm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        EntityId $originator = this.getOriginator();
        result = result * 59 + ($originator == null ? 43 : $originator.hashCode());
        AlarmSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        AlarmStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        long $ackTs = this.getAckTs();
        result = result * 59 + (int)($ackTs >>> 32 ^ $ackTs);
        long $clearTs = this.getClearTs();
        result = result * 59 + (int)($clearTs >>> 32 ^ $clearTs);
        result = result * 59 + (this.isPropagate() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "Alarm(tenantId=" + this.getTenantId() + ", type=" + this.getType() + ", originator=" + this.getOriginator() + ", severity=" + (Object)((Object)this.getSeverity()) + ", status=" + (Object)((Object)this.getStatus()) + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", ackTs=" + this.getAckTs() + ", clearTs=" + this.getClearTs() + ", details=" + this.getDetails() + ", propagate=" + this.isPropagate() + ")";
    }

    @ConstructorProperties(value={"tenantId", "type", "originator", "severity", "status", "startTs", "endTs", "ackTs", "clearTs", "details", "propagate"})
    public Alarm(TenantId tenantId, String type, EntityId originator, AlarmSeverity severity, AlarmStatus status, long startTs, long endTs, long ackTs, long clearTs, JsonNode details, boolean propagate) {
        this.tenantId = tenantId;
        this.type = type;
        this.originator = originator;
        this.severity = severity;
        this.status = status;
        this.startTs = startTs;
        this.endTs = endTs;
        this.ackTs = ackTs;
        this.clearTs = clearTs;
        this.details = details;
        this.propagate = propagate;
    }

    public static class AlarmBuilder {
        private TenantId tenantId;
        private String type;
        private EntityId originator;
        private AlarmSeverity severity;
        private AlarmStatus status;
        private long startTs;
        private long endTs;
        private long ackTs;
        private long clearTs;
        private JsonNode details;
        private boolean propagate;

        AlarmBuilder() {
        }

        public AlarmBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AlarmBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AlarmBuilder originator(EntityId originator) {
            this.originator = originator;
            return this;
        }

        public AlarmBuilder severity(AlarmSeverity severity) {
            this.severity = severity;
            return this;
        }

        public AlarmBuilder status(AlarmStatus status) {
            this.status = status;
            return this;
        }

        public AlarmBuilder startTs(long startTs) {
            this.startTs = startTs;
            return this;
        }

        public AlarmBuilder endTs(long endTs) {
            this.endTs = endTs;
            return this;
        }

        public AlarmBuilder ackTs(long ackTs) {
            this.ackTs = ackTs;
            return this;
        }

        public AlarmBuilder clearTs(long clearTs) {
            this.clearTs = clearTs;
            return this;
        }

        public AlarmBuilder details(JsonNode details) {
            this.details = details;
            return this;
        }

        public AlarmBuilder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public Alarm build() {
            return new Alarm(this.tenantId, this.type, this.originator, this.severity, this.status, this.startTs, this.endTs, this.ackTs, this.clearTs, this.details, this.propagate);
        }

        public String toString() {
            return "Alarm.AlarmBuilder(tenantId=" + this.tenantId + ", type=" + this.type + ", originator=" + this.originator + ", severity=" + (Object)((Object)this.severity) + ", status=" + (Object)((Object)this.status) + ", startTs=" + this.startTs + ", endTs=" + this.endTs + ", ackTs=" + this.ackTs + ", clearTs=" + this.clearTs + ", details=" + this.details + ", propagate=" + this.propagate + ")";
        }
    }
}

