/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.Authority;

public class User
extends SearchTextBasedWithAdditionalInfo<UserId>
implements HasName,
TenantEntity,
HasCustomerId,
HasOwnerId {
    private static final long serialVersionUID = 8250339805336035966L;
    private TenantId tenantId;
    private CustomerId customerId;
    private String email;
    private Authority authority;
    private String firstName;
    private String lastName;

    public User() {
    }

    public User(UserId id) {
        super(id);
    }

    public User(User user) {
        super(user);
        this.tenantId = user.getTenantId();
        this.customerId = user.getCustomerId();
        this.email = user.getEmail();
        this.authority = user.getAuthority();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Override
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.email;
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getSearchText() {
        return this.getEmail();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("User [tenantId=");
        builder.append(this.tenantId);
        builder.append(", customerId=");
        builder.append(this.customerId);
        builder.append(", email=");
        builder.append(this.email);
        builder.append(", authority=");
        builder.append((Object)this.authority);
        builder.append(", firstName=");
        builder.append(this.firstName);
        builder.append(", lastName=");
        builder.append(this.lastName);
        builder.append(", additionalInfo=");
        builder.append(this.getAdditionalInfo());
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @JsonIgnore
    public boolean isSystemAdmin() {
        return this.tenantId == null || EntityId.NULL_UUID.equals(this.tenantId.getId());
    }

    @JsonIgnore
    public boolean isTenantAdmin() {
        return !this.isSystemAdmin() && (this.customerId == null || EntityId.NULL_UUID.equals(this.customerId.getId()));
    }

    @JsonIgnore
    public boolean isCustomerUser() {
        return !this.isSystemAdmin() && !this.isTenantAdmin();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.USER;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Authority this$authority = this.getAuthority();
        Authority other$authority = other.getAuthority();
        if (this$authority == null ? other$authority != null : !((Object)((Object)this$authority)).equals((Object)other$authority)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        return !(this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Authority $authority = this.getAuthority();
        result = result * 59 + ($authority == null ? 43 : ((Object)((Object)$authority)).hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        return result;
    }
}

