/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.HasAdditionalInfo;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.id.UUIDBased;

public abstract class SearchTextBasedWithAdditionalInfo<I extends UUIDBased>
extends SearchTextBased<I>
implements HasAdditionalInfo {
    private static final Logger log = LoggerFactory.getLogger(SearchTextBasedWithAdditionalInfo.class);
    private transient JsonNode additionalInfo;
    @JsonIgnore
    private byte[] additionalInfoBytes;

    public SearchTextBasedWithAdditionalInfo() {
    }

    public SearchTextBasedWithAdditionalInfo(I id) {
        super(id);
    }

    public SearchTextBasedWithAdditionalInfo(SearchTextBasedWithAdditionalInfo<I> searchTextBased) {
        super(searchTextBased);
        this.setAdditionalInfo(searchTextBased.getAdditionalInfo());
    }

    @Override
    public JsonNode getAdditionalInfo() {
        return SearchTextBasedWithAdditionalInfo.getJson(() -> this.additionalInfo, () -> this.additionalInfoBytes);
    }

    public void setAdditionalInfo(JsonNode addInfo) {
        SearchTextBasedWithAdditionalInfo.setJson(addInfo, json -> {
            this.additionalInfo = json;
        }, bytes -> {
            this.additionalInfoBytes = bytes;
        });
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchTextBasedWithAdditionalInfo that = (SearchTextBasedWithAdditionalInfo)o;
        return Arrays.equals(this.additionalInfoBytes, that.additionalInfoBytes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.additionalInfoBytes);
    }

    public static JsonNode getJson(Supplier<JsonNode> jsonData, Supplier<byte[]> binaryData) {
        JsonNode json = jsonData.get();
        if (json != null) {
            return json;
        }
        byte[] data = binaryData.get();
        if (data != null) {
            try {
                return new ObjectMapper().readTree((InputStream)new ByteArrayInputStream(data));
            }
            catch (IOException e) {
                log.warn("Can't deserialize json data: ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static void setJson(JsonNode json, Consumer<JsonNode> jsonConsumer, Consumer<byte[]> bytesConsumer) {
        jsonConsumer.accept(json);
        try {
            bytesConsumer.accept(new ObjectMapper().writeValueAsBytes((Object)json));
        }
        catch (JsonProcessingException e) {
            log.warn("Can't serialize json data: ", (Throwable)e);
        }
    }
}

