/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;

public class JacksonUtils {
    private JacksonUtils() {
    }

    public static JsonNode merge(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            JsonNode value;
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null) {
                if (jsonNode.isObject()) {
                    JacksonUtils.merge(jsonNode, updateNode.get(fieldName));
                    continue;
                }
                if (!jsonNode.isArray()) continue;
                for (int i = 0; i < jsonNode.size(); ++i) {
                    JacksonUtils.merge(jsonNode.get(i), updateNode.get(fieldName).get(i));
                }
                continue;
            }
            if (!(mainNode instanceof ObjectNode) || (value = updateNode.get(fieldName)).isNull() || value.isIntegralNumber() && value.toString().equals("0") || value.isFloatingPointNumber() && value.toString().equals("0.0")) continue;
            ((ObjectNode)mainNode).put(fieldName, value);
        }
        return mainNode;
    }
}

