/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EventId;
import org.thingsboard.server.common.data.id.TenantId;

public class Event
extends BaseData<EventId> {
    private static final Logger log = LoggerFactory.getLogger(Event.class);
    private TenantId tenantId;
    private String type;
    private String uid;
    private EntityId entityId;
    private transient JsonNode body;
    @JsonIgnore
    private byte[] bodyBytes;

    public Event() {
    }

    public Event(EventId id) {
        super(id);
    }

    public Event(Event event) {
        super(event);
        this.setBody(event.getBody());
    }

    public JsonNode getBody() {
        return SearchTextBasedWithAdditionalInfo.getJson(() -> this.body, () -> this.bodyBytes);
    }

    public void setBody(JsonNode body) {
        SearchTextBasedWithAdditionalInfo.setJson(body, json -> {
            this.body = json;
        }, bytes -> {
            this.bodyBytes = bytes;
        });
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getType() {
        return this.type;
    }

    public String getUid() {
        return this.uid;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    public void setBodyBytes(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        return Arrays.equals(this.getBodyBytes(), other.getBodyBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBodyBytes());
        return result;
    }

    @Override
    public String toString() {
        return "Event(tenantId=" + this.getTenantId() + ", type=" + this.getType() + ", uid=" + this.getUid() + ", entityId=" + this.getEntityId() + ", body=" + this.getBody() + ", bodyBytes=" + Arrays.toString(this.getBodyBytes()) + ")";
    }
}

