/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.objects.TelemetryEntityView;

public class EntityView
extends SearchTextBasedWithAdditionalInfo<EntityViewId>
implements HasName,
TenantEntity,
HasCustomerId,
HasOwnerId {
    private static final long serialVersionUID = 5582010124562018986L;
    private EntityId entityId;
    private TenantId tenantId;
    private CustomerId customerId;
    private String name;
    private String type;
    private TelemetryEntityView keys;
    private long startTimeMs;
    private long endTimeMs;

    public EntityView() {
    }

    public EntityView(EntityViewId id) {
        super(id);
    }

    public EntityView(EntityView entityView) {
        super(entityView);
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.ENTITY_VIEW;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public String getType() {
        return this.type;
    }

    public TelemetryEntityView getKeys() {
        return this.keys;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public long getEndTimeMs() {
        return this.endTimeMs;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setKeys(TelemetryEntityView keys) {
        this.keys = keys;
    }

    public void setStartTimeMs(long startTimeMs) {
        this.startTimeMs = startTimeMs;
    }

    public void setEndTimeMs(long endTimeMs) {
        this.endTimeMs = endTimeMs;
    }

    @Override
    public String toString() {
        return "EntityView(entityId=" + this.getEntityId() + ", tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ", name=" + this.getName() + ", type=" + this.getType() + ", keys=" + this.getKeys() + ", startTimeMs=" + this.getStartTimeMs() + ", endTimeMs=" + this.getEndTimeMs() + ")";
    }

    @ConstructorProperties(value={"entityId", "tenantId", "customerId", "name", "type", "keys", "startTimeMs", "endTimeMs"})
    public EntityView(EntityId entityId, TenantId tenantId, CustomerId customerId, String name, String type, TelemetryEntityView keys, long startTimeMs, long endTimeMs) {
        this.entityId = entityId;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.name = name;
        this.type = type;
        this.keys = keys;
        this.startTimeMs = startTimeMs;
        this.endTimeMs = endTimeMs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityView)) {
            return false;
        }
        EntityView other = (EntityView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        TelemetryEntityView this$keys = this.getKeys();
        TelemetryEntityView other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        if (this.getStartTimeMs() != other.getStartTimeMs()) {
            return false;
        }
        return this.getEndTimeMs() == other.getEndTimeMs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityView;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        TelemetryEntityView $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        long $startTimeMs = this.getStartTimeMs();
        result = result * 59 + (int)($startTimeMs >>> 32 ^ $startTimeMs);
        long $endTimeMs = this.getEndTimeMs();
        result = result * 59 + (int)($endTimeMs >>> 32 ^ $endTimeMs);
        return result;
    }
}

