/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.ShortCustomerInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public class Customer
extends ContactBased<CustomerId>
implements TenantEntity,
HasCustomerId,
HasOwnerId {
    private static final long serialVersionUID = -1599722990298929275L;
    private String title;
    private TenantId tenantId;
    private CustomerId parentCustomerId;

    public Customer() {
    }

    public Customer(CustomerId id) {
        super(id);
    }

    public Customer(Customer customer) {
        super(customer);
        this.tenantId = customer.getTenantId();
        this.title = customer.getTitle();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public CustomerId getParentCustomerId() {
        return this.parentCustomerId;
    }

    public void setParentCustomerId(CustomerId parentCustomerId) {
        this.parentCustomerId = parentCustomerId;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public CustomerId getCustomerId() {
        return this.parentCustomerId;
    }

    @Override
    public EntityId getOwnerId() {
        return this.parentCustomerId != null && !this.parentCustomerId.isNullUid() ? this.parentCustomerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.parentCustomerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @JsonIgnore
    public boolean isSubCustomer() {
        return this.parentCustomerId != null && !this.parentCustomerId.isNullUid();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonIgnore
    public boolean isPublic() {
        if (this.getAdditionalInfo() != null && this.getAdditionalInfo().has("isPublic")) {
            return this.getAdditionalInfo().get("isPublic").asBoolean();
        }
        return false;
    }

    @JsonIgnore
    public ShortCustomerInfo toShortCustomerInfo() {
        return new ShortCustomerInfo((CustomerId)this.id, this.title, this.isPublic());
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @Override
    public String getSearchText() {
        return this.getTitle();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Customer other = (Customer)obj;
        if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Customer [title=");
        builder.append(this.title);
        builder.append(", tenantId=");
        builder.append(this.tenantId);
        builder.append(", additionalInfo=");
        builder.append(this.getAdditionalInfo());
        builder.append(", country=");
        builder.append(this.country);
        builder.append(", state=");
        builder.append(this.state);
        builder.append(", city=");
        builder.append(this.city);
        builder.append(", address=");
        builder.append(this.address);
        builder.append(", address2=");
        builder.append(this.address2);
        builder.append(", zip=");
        builder.append(this.zip);
        builder.append(", phone=");
        builder.append(this.phone);
        builder.append(", email=");
        builder.append(this.email);
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.CUSTOMER;
    }
}

