/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.user;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.UserInfo;
import org.thingsboard.server.common.data.id.CustomMenuId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.id.UserCredentialsId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.mobile.MobileSessionInfo;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface UserService
extends EntityDaoService {
    public User findUserById(TenantId var1, UserId var2);

    public UserInfo findUserInfoById(TenantId var1, UserId var2);

    public ListenableFuture<User> findUserByIdAsync(TenantId var1, UserId var2);

    public ListenableFuture<List<User>> findUsersByTenantIdAndIdsAsync(TenantId var1, List<UserId> var2);

    public User findUserByEmail(TenantId var1, String var2);

    public User findUserByTenantIdAndEmail(TenantId var1, String var2);

    public ListenableFuture<User> findUserByTenantIdAndEmailAsync(TenantId var1, String var2);

    public User changeOwner(User var1, EntityId var2);

    public User saveUser(TenantId var1, User var2);

    public UserCredentials findUserCredentialsByUserId(TenantId var1, UserId var2);

    public UserCredentials findUserCredentialsByActivateToken(TenantId var1, String var2);

    public UserCredentials findUserCredentialsByResetToken(TenantId var1, String var2);

    public UserCredentials saveUserCredentials(TenantId var1, UserCredentials var2);

    public UserCredentials activateUserCredentials(TenantId var1, String var2, String var3);

    public UserCredentials requestPasswordReset(TenantId var1, String var2);

    public UserCredentials requestExpiredPasswordReset(TenantId var1, UserCredentialsId var2);

    public UserCredentials generatePasswordResetToken(UserCredentials var1);

    public UserCredentials generateUserActivationToken(UserCredentials var1);

    public UserCredentials checkUserActivationToken(TenantId var1, UserCredentials var2);

    public UserCredentials replaceUserCredentials(TenantId var1, UserCredentials var2);

    public void deleteUser(TenantId var1, UserId var2);

    public void deleteUser(TenantId var1, User var2);

    public PageData<User> findTenantAdmins(TenantId var1, PageLink var2);

    public PageData<User> findUsersByTenantId(TenantId var1, PageLink var2);

    public PageData<User> findSysAdmins(PageLink var1);

    public PageData<User> findAllTenantAdmins(PageLink var1);

    public PageData<User> findTenantAdminsByTenantsIds(List<TenantId> var1, PageLink var2);

    public PageData<User> findTenantAdminsByTenantProfilesIds(List<TenantProfileId> var1, PageLink var2);

    public PageData<User> findAllUsers(PageLink var1);

    public void deleteTenantAdmins(TenantId var1);

    public PageData<User> findAllCustomerUsers(TenantId var1, PageLink var2);

    public void deleteAllByTenantId(TenantId var1);

    public PageData<User> findCustomerUsers(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<User> findUsersByCustomerIds(TenantId var1, List<CustomerId> var2, PageLink var3);

    public void deleteCustomerUsers(TenantId var1, CustomerId var2);

    public PageData<User> findUsersByEntityGroupId(EntityGroupId var1, PageLink var2);

    public PageData<User> findUsersByEntityGroupIds(List<EntityGroupId> var1, PageLink var2);

    public PageData<User> findUsersByTenantIdAndRoles(TenantId var1, List<RoleId> var2, PageLink var3);

    public PageData<User> findUsersByTenantsIdsAndRoleId(List<TenantId> var1, RoleId var2, PageLink var3);

    public PageData<User> findUsersByTenantProfilesIdsAndRoleId(List<TenantProfileId> var1, RoleId var2, PageLink var3);

    public PageData<User> findAllUsersByRoleId(RoleId var1, PageLink var2);

    public int countUsersByTenantIdAndRoleIdAndIdNotIn(TenantId var1, RoleId var2, List<UserId> var3);

    public void setUserCredentialsEnabled(TenantId var1, UserId var2, boolean var3);

    public void resetFailedLoginAttempts(TenantId var1, UserId var2);

    public int increaseFailedLoginAttempts(TenantId var1, UserId var2);

    public void updateLastLoginTs(TenantId var1, UserId var2);

    public PageData<UserInfo> findUserInfosByTenantId(TenantId var1, PageLink var2);

    public PageData<UserInfo> findTenantUserInfosByTenantId(TenantId var1, PageLink var2);

    public PageData<UserInfo> findUserInfosByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<UserInfo> findUserInfosByTenantIdAndCustomerIdIncludingSubCustomers(TenantId var1, CustomerId var2, PageLink var3);

    public void saveMobileSession(TenantId var1, UserId var2, String var3, MobileSessionInfo var4);

    public Map<String, MobileSessionInfo> findMobileSessions(TenantId var1, UserId var2);

    public MobileSessionInfo findMobileSession(TenantId var1, UserId var2, String var3);

    public void removeMobileSession(TenantId var1, String var2);

    public List<User> findUsersByCustomMenuId(CustomMenuId var1);

    public void updateUsersCustomMenuId(List<UserId> var1, CustomMenuId var2);
}

