/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.timeseries;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.DeleteTsKvQuery;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;
import org.thingsboard.server.common.data.kv.ReadTsKvQueryResult;
import org.thingsboard.server.common.data.kv.TimeseriesSaveResult;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.kv.TsKvLatestRemovingResult;

public interface TimeseriesService {
    public ListenableFuture<TsKvEntry> findOne(TenantId var1, EntityId var2, long var3, String var5);

    public ListenableFuture<List<ReadTsKvQueryResult>> findAllByQueries(TenantId var1, EntityId var2, List<ReadTsKvQuery> var3);

    public ListenableFuture<List<TsKvEntry>> findAll(TenantId var1, EntityId var2, List<ReadTsKvQuery> var3);

    public ListenableFuture<Optional<TsKvEntry>> findLatest(TenantId var1, EntityId var2, String var3);

    public ListenableFuture<List<TsKvEntry>> findLatest(TenantId var1, EntityId var2, Collection<String> var3);

    public ListenableFuture<List<TsKvEntry>> findAllLatest(TenantId var1, EntityId var2);

    public ListenableFuture<TimeseriesSaveResult> save(TenantId var1, EntityId var2, TsKvEntry var3);

    public ListenableFuture<TimeseriesSaveResult> save(TenantId var1, EntityId var2, List<TsKvEntry> var3, long var4);

    public ListenableFuture<TimeseriesSaveResult> save(TenantId var1, EntityId var2, List<TsKvEntry> var3, long var4, boolean var6);

    public ListenableFuture<TimeseriesSaveResult> saveWithoutLatest(TenantId var1, EntityId var2, List<TsKvEntry> var3, long var4);

    public ListenableFuture<TimeseriesSaveResult> saveWithoutLatest(TenantId var1, EntityId var2, List<TsKvEntry> var3, long var4, boolean var6);

    public ListenableFuture<TimeseriesSaveResult> saveLatest(TenantId var1, EntityId var2, List<TsKvEntry> var3);

    public ListenableFuture<List<TsKvLatestRemovingResult>> remove(TenantId var1, EntityId var2, List<DeleteTsKvQuery> var3);

    public ListenableFuture<List<TsKvLatestRemovingResult>> removeLatest(TenantId var1, EntityId var2, Collection<String> var3);

    public ListenableFuture<List<String>> removeAllLatest(TenantId var1, EntityId var2);

    public List<String> findAllKeysByDeviceProfileId(TenantId var1, DeviceProfileId var2);

    public List<String> findAllKeysByEntityIds(TenantId var1, List<EntityId> var2);

    public void cleanup(long var1);
}

