/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.scheduler;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.report.ScheduledReportQuery;
import org.thingsboard.server.common.data.scheduler.ScheduledReportInfo;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.scheduler.SchedulerEventFilter;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;
import org.thingsboard.server.common.data.scheduler.SchedulerEventTimeFilter;
import org.thingsboard.server.common.data.scheduler.SchedulerEventWithCustomerInfo;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface SchedulerEventService
extends EntityDaoService {
    public SchedulerEvent findSchedulerEventById(TenantId var1, SchedulerEventId var2);

    public SchedulerEventInfo findSchedulerEventInfoById(TenantId var1, SchedulerEventId var2);

    public SchedulerEventWithCustomerInfo findSchedulerEventWithCustomerInfoById(TenantId var1, SchedulerEventId var2);

    public ListenableFuture<SchedulerEventInfo> findSchedulerEventInfoByIdAsync(TenantId var1, SchedulerEventId var2);

    public ListenableFuture<List<SchedulerEventInfo>> findSchedulerEventInfoByIdsAsync(TenantId var1, List<SchedulerEventId> var2);

    public List<SchedulerEventInfo> findSchedulerEventsByTenantId(TenantId var1);

    public List<SchedulerEventInfo> findSchedulerEventsByTenantIdAndEnabled(TenantId var1, boolean var2);

    public PageData<SchedulerEventWithCustomerInfo> findSchedulerEventsByTenantIdAndFilter(TenantId var1, SchedulerEventFilter var2, PageLink var3);

    public List<SchedulerEventWithCustomerInfo> findAllSchedulerEventsByTenantIdAndEventTimeFilter(TenantId var1, SchedulerEventTimeFilter var2, String var3);

    public SchedulerEvent saveSchedulerEvent(SchedulerEvent var1);

    public void deleteSchedulerEvent(TenantId var1, SchedulerEventId var2);

    public void deleteSchedulerEventsByTenantId(TenantId var1);

    public void deleteSchedulerEventsByTenantIdAndCustomerId(TenantId var1, CustomerId var2);

    public SchedulerEventInfo assignSchedulerEventToEdge(TenantId var1, SchedulerEventId var2, EdgeId var3);

    public SchedulerEventInfo unassignSchedulerEventFromEdge(TenantId var1, SchedulerEventId var2, EdgeId var3);

    public PageData<SchedulerEvent> findSchedulerEventsByTenantIdAndEdgeId(TenantId var1, EdgeId var2, PageLink var3);

    public PageData<SchedulerEventInfo> findSchedulerEventInfosByTenantIdAndEdgeId(TenantId var1, EdgeId var2, PageLink var3);

    public PageData<SchedulerEventInfo> findSchedulerEventInfosByTenantIdAndEdgeIdAndCustomerId(TenantId var1, EdgeId var2, CustomerId var3, PageLink var4);

    public PageData<ScheduledReportInfo> findScheduledReportEvents(TenantId var1, ScheduledReportQuery var2);

    public PageData<ScheduledReportInfo> findScheduledReportEvents(TenantId var1, CustomerId var2, ScheduledReportQuery var3);

    public int countScheduledReportEventsByTemplateId(TenantId var1, ReportTemplateId var2);
}

