/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.resource;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.ResourceExportData;
import org.thingsboard.server.common.data.ResourceSubType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceDataInfo;
import org.thingsboard.server.common.data.TbResourceDeleteResult;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.TbResourceInfoFilter;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface ResourceService
extends EntityDaoService {
    public TbResource saveResource(TbResource var1);

    public TbResource saveResource(TbResource var1, boolean var2);

    public TbResource findResourceByTenantIdAndKey(TenantId var1, ResourceType var2, String var3);

    public TbResource findResourceById(TenantId var1, TbResourceId var2);

    public byte[] getResourceData(TenantId var1, TbResourceId var2);

    public TbResourceDataInfo getResourceDataInfo(TenantId var1, TbResourceId var2);

    public ResourceExportData exportResource(TbResourceInfo var1);

    public List<ResourceExportData> exportResources(TenantId var1, Collection<TbResourceInfo> var2);

    public TbResource toResource(TenantId var1, ResourceExportData var2);

    public void importResources(TenantId var1, CustomerId var2, List<ResourceExportData> var3);

    public TbResourceInfo findResourceInfoById(TenantId var1, TbResourceId var2);

    public TbResourceInfo findResourceInfoByTenantIdAndKey(TenantId var1, ResourceType var2, String var3);

    public PageData<TbResource> findAllTenantResources(TenantId var1, PageLink var2);

    public ListenableFuture<TbResourceInfo> findResourceInfoByIdAsync(TenantId var1, TbResourceId var2);

    public PageData<TbResourceInfo> findAllTenantResourcesByTenantId(TbResourceInfoFilter var1, PageLink var2);

    public PageData<TbResourceInfo> findTenantResourcesByTenantId(TbResourceInfoFilter var1, PageLink var2);

    public List<TbResource> findTenantResourcesByResourceTypeAndObjectIds(TenantId var1, ResourceType var2, String[] var3);

    public PageData<TbResource> findTenantResourcesByResourceTypeAndPageLink(TenantId var1, ResourceType var2, PageLink var3);

    public TbResourceDeleteResult deleteResource(TenantId var1, TbResourceId var2, boolean var3);

    public void deleteResourcesByTenantId(TenantId var1);

    public long sumDataSizeByTenantId(TenantId var1);

    public String calculateEtag(byte[] var1);

    public TbResourceInfo findSystemOrTenantResourceByEtag(TenantId var1, ResourceType var2, String var3);

    public boolean updateResourcesUsage(TenantId var1, Dashboard var2);

    public boolean updateResourcesUsage(TenantId var1, WidgetTypeDetails var2);

    public Collection<TbResourceInfo> getUsedResources(TenantId var1, Dashboard var2);

    public Collection<TbResourceInfo> getUsedResources(TenantId var1, WidgetTypeDetails var2);

    public TbResource createOrUpdateSystemResource(ResourceType var1, ResourceSubType var2, String var3, byte[] var4);

    public List<TbResourceInfo> findSystemOrTenantResourcesByIds(TenantId var1, List<TbResourceId> var2);
}

