/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.resource;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.HasImage;
import org.thingsboard.server.common.data.ResourceExportData;
import org.thingsboard.server.common.data.ResourceSubType;
import org.thingsboard.server.common.data.TbImageDeleteResult;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.common.data.wl.WhiteLabeling;

public interface ImageService {
    public TbResourceInfo saveImage(TbResource var1);

    public TbResourceInfo saveImageInfo(TbResourceInfo var1);

    public TbResourceInfo getImageInfoByTenantIdAndKey(TenantId var1, String var2);

    public TbResourceInfo getImageInfoByTenantIdAndCustomerIdAndKey(TenantId var1, CustomerId var2, String var3);

    public TbResourceInfo getPublicImageInfoByKey(String var1);

    public PageData<TbResourceInfo> getImagesByTenantId(TenantId var1, ResourceSubType var2, PageLink var3);

    public PageData<TbResourceInfo> getImagesByCustomerId(TenantId var1, CustomerId var2, ResourceSubType var3, PageLink var4);

    public PageData<TbResourceInfo> getAllImagesByTenantId(TenantId var1, ResourceSubType var2, PageLink var3);

    public byte[] getImageData(TenantId var1, TbResourceId var2);

    public byte[] getImagePreview(TenantId var1, TbResourceId var2);

    public ResourceExportData exportImage(TbResourceInfo var1);

    public TbResource toImage(TenantId var1, CustomerId var2, ResourceExportData var3, boolean var4);

    public TbImageDeleteResult deleteImage(TbResourceInfo var1, boolean var2);

    public String calculateImageEtag(byte[] var1);

    public TbResourceInfo findSystemOrTenantImageByEtag(TenantId var1, String var2);

    public TbResourceInfo findSystemOrCustomerImageByEtag(TenantId var1, CustomerId var2, String var3);

    public boolean replaceBase64WithImageUrl(HasImage var1, String var2);

    public boolean replaceBase64WithImageUrl(WhiteLabeling var1);

    public boolean updateImagesUsage(Dashboard var1);

    public boolean updateImagesUsage(WidgetTypeDetails var1);

    public <T extends HasImage> T inlineImage(T var1);

    public Collection<TbResourceInfo> getUsedImages(Dashboard var1);

    public Collection<TbResourceInfo> getUsedImages(WidgetTypeDetails var1);

    public void inlineImageForEdge(HasImage var1);

    public void inlineImagesForEdge(Dashboard var1);

    public void inlineImagesForEdge(WidgetTypeDetails var1);

    public void inlineImagesForEdge(TenantId var1, JsonNode var2);

    public TbResourceInfo createOrUpdateSystemImage(String var1, byte[] var2);
}

