/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.group;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ShortEntityView;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface EntityGroupService
extends EntityDaoService {
    public EntityGroup findEntityGroupById(TenantId var1, EntityGroupId var2);

    public EntityGroupInfo findEntityGroupInfoById(TenantId var1, EntityGroupId var2);

    public EntityInfo findEntityGroupEntityInfoById(TenantId var1, EntityGroupId var2);

    public ListenableFuture<EntityGroup> findEntityGroupByIdAsync(TenantId var1, EntityGroupId var2);

    public ListenableFuture<EntityGroupInfo> findEntityGroupInfoByIdAsync(TenantId var1, EntityGroupId var2);

    public EntityGroup saveEntityGroup(TenantId var1, EntityId var2, EntityGroup var3);

    public EntityGroup createEntityGroupAll(TenantId var1, EntityId var2, EntityType var3);

    public void createDefaultTenantEntityGroups(TenantId var1);

    public void createDefaultCustomerEntityGroups(TenantId var1, Customer var2);

    public EntityGroup findOrCreateUserGroup(TenantId var1, EntityId var2, String var3, String var4);

    public EntityGroup findOrCreateEntityGroup(TenantId var1, EntityId var2, EntityType var3, String var4, String var5, CustomerId var6);

    public Optional<EntityGroupInfo> findOwnerEntityGroupInfo(TenantId var1, EntityId var2, EntityType var3, String var4);

    public EntityGroup findOrCreateTenantUsersGroup(TenantId var1);

    public EntityGroup findOrCreateTenantAdminsGroup(TenantId var1);

    public EntityGroup findOrCreateCustomerUsersGroup(TenantId var1, CustomerId var2, CustomerId var3);

    public EntityGroup findOrCreateCustomerAdminsGroup(TenantId var1, CustomerId var2, CustomerId var3);

    public EntityGroup findOrCreatePublicUsersGroup(TenantId var1, CustomerId var2);

    public EntityGroup findOrCreateReadOnlyEntityGroupForCustomer(TenantId var1, CustomerId var2, EntityType var3);

    public ListenableFuture<Optional<EntityGroup>> findPublicUserGroupAsync(TenantId var1, CustomerId var2);

    public void deleteEntityGroup(TenantId var1, EntityGroupId var2);

    public PageData<EntityGroup> findAllEntityGroupsByParentRelation(TenantId var1, EntityId var2, PageLink var3);

    public void deleteAllEntityGroups(TenantId var1, EntityId var2);

    public PageData<EntityGroup> findEntityGroupsByType(TenantId var1, EntityId var2, EntityType var3, PageLink var4);

    public PageData<EntityGroupInfo> findEntityGroupInfosByType(TenantId var1, EntityId var2, EntityType var3, PageLink var4);

    public PageData<EntityInfo> findEntityGroupEntityInfosByType(TenantId var1, EntityId var2, EntityType var3, PageLink var4);

    public PageData<EntityGroupInfo> findEntityGroupInfosByOwnersAndType(TenantId var1, List<EntityId> var2, EntityType var3, PageLink var4);

    public PageData<EntityInfo> findEntityGroupEntityInfosByOwnersAndType(TenantId var1, List<EntityId> var2, EntityType var3, PageLink var4);

    public PageData<EntityGroupInfo> findEntityGroupInfosByIds(TenantId var1, List<EntityGroupId> var2, PageLink var3);

    public PageData<EntityInfo> findEntityGroupEntityInfosByIds(TenantId var1, List<EntityGroupId> var2, PageLink var3);

    public PageData<EntityGroupInfo> findEntityGroupInfosByTypeOrIds(TenantId var1, EntityId var2, EntityType var3, List<EntityGroupId> var4, PageLink var5);

    public PageData<EntityInfo> findEntityGroupEntityInfosByTypeOrIds(TenantId var1, EntityId var2, EntityType var3, List<EntityGroupId> var4, PageLink var5);

    public PageData<EntityGroupInfo> findEdgeEntityGroupInfosByOwnerIdType(TenantId var1, EdgeId var2, EntityId var3, EntityType var4, PageLink var5);

    public PageData<EntityGroup> findEntityGroupsByType(TenantId var1, EntityType var2, PageLink var3);

    public Optional<EntityGroup> findEntityGroupByTypeAndName(TenantId var1, EntityId var2, EntityType var3, String var4);

    public Optional<EntityGroup> findEntityGroupByTypeAndName(TenantId var1, EntityId var2, EntityType var3, String var4, boolean var5);

    public Optional<EntityGroupInfo> findEntityGroupInfoByTypeAndName(TenantId var1, EntityId var2, EntityType var3, String var4);

    public ListenableFuture<Optional<EntityGroup>> findEntityGroupByTypeAndNameAsync(TenantId var1, EntityId var2, EntityType var3, String var4);

    public void addEntityToEntityGroup(TenantId var1, EntityGroupId var2, EntityId var3);

    public void addEntityToEntityGroupAll(TenantId var1, EntityId var2, EntityId var3);

    public void addEntitiesToEntityGroup(TenantId var1, EntityGroupId var2, List<EntityId> var3);

    public void removeEntityFromEntityGroup(TenantId var1, EntityGroupId var2, EntityId var3);

    public void removeEntitiesFromEntityGroup(TenantId var1, EntityGroupId var2, List<EntityId> var3);

    public ShortEntityView findGroupEntity(TenantId var1, CustomerId var2, MergedUserPermissions var3, EntityGroupId var4, EntityId var5);

    public PageData<ShortEntityView> findGroupEntities(TenantId var1, CustomerId var2, MergedUserPermissions var3, EntityGroupId var4, PageLink var5);

    public ListenableFuture<List<EntityId>> findAllEntityIdsAsync(TenantId var1, EntityGroupId var2, PageLink var3);

    public PageData<EntityId> findEntityIds(TenantId var1, EntityType var2, EntityGroupId var3, PageLink var4);

    public ListenableFuture<List<EntityGroupId>> findEntityGroupsForEntityAsync(TenantId var1, EntityId var2);

    public boolean isEntityInGroup(TenantId var1, EntityId var2, EntityGroupId var3);

    public EntityGroup assignEntityGroupToEdge(TenantId var1, EntityGroupId var2, EdgeId var3, EntityType var4);

    public EntityGroup unassignEntityGroupFromEdge(TenantId var1, EntityGroupId var2, EdgeId var3, EntityType var4);

    public PageData<EntityGroup> findEdgeEntityGroupsByType(TenantId var1, EdgeId var2, EntityType var3, PageLink var4);

    public PageData<EntityGroup> findEdgeEntityGroupsByOwnerIdAndType(TenantId var1, EdgeId var2, EntityId var3, EntityType var4, PageLink var5);

    public ListenableFuture<Boolean> checkEntityGroupAssignedToEdgeAsync(TenantId var1, EdgeId var2, EntityGroupId var3, EntityType var4);

    public ListenableFuture<EntityGroup> findOrCreateEdgeAllGroupAsync(TenantId var1, Edge var2, String var3, EntityType var4, EntityType var5);

    public boolean isTenantAdminUserGroup(EntityGroup var1);

    public boolean containsLastTenantAdmin(TenantId var1, List<UserId> var2);
}

