/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.device;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceIdInfo;
import org.thingsboard.server.common.data.DeviceInfo;
import org.thingsboard.server.common.data.DeviceInfoFilter;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.ProfileEntityIdInfo;
import org.thingsboard.server.common.data.device.DeviceSearchQuery;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.dao.device.provision.ProvisionRequest;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface DeviceService
extends EntityDaoService {
    public Device findDeviceById(TenantId var1, DeviceId var2);

    public DeviceInfo findDeviceInfoById(TenantId var1, DeviceId var2);

    public EntityInfo findDeviceEntityInfoById(TenantId var1, DeviceId var2);

    public ListenableFuture<Device> findDeviceByIdAsync(TenantId var1, DeviceId var2);

    public Device findDeviceByTenantIdAndName(TenantId var1, String var2);

    public ListenableFuture<Device> findDeviceByTenantIdAndNameAsync(TenantId var1, String var2);

    public Device saveDevice(Device var1);

    public Device saveDevice(Device var1, boolean var2);

    public Device saveDeviceWithAccessToken(Device var1, String var2);

    public Device saveDeviceWithCredentials(Device var1, DeviceCredentials var2);

    public Device saveDevice(ProvisionRequest var1, DeviceProfile var2);

    public void deleteDevice(TenantId var1, DeviceId var2);

    public PageData<Device> findDevicesByTenantId(TenantId var1, PageLink var2);

    public PageData<Device> findDevicesByTenantIdAndType(TenantId var1, String var2, PageLink var3);

    public Long countDevices();

    public PageData<DeviceInfo> findDeviceInfosByFilter(DeviceInfoFilter var1, PageLink var2);

    public PageData<DeviceIdInfo> findDeviceIdInfos(PageLink var1);

    public PageData<ProfileEntityIdInfo> findProfileEntityIdInfos(PageLink var1);

    public PageData<ProfileEntityIdInfo> findProfileEntityIdInfosByTenantId(TenantId var1, PageLink var2);

    public PageData<DeviceId> findDeviceIdsByTenantIdAndDeviceProfileId(TenantId var1, DeviceProfileId var2, PageLink var3);

    public PageData<EntityInfo> findDeviceEntityInfosByTenantIdAndDeviceProfileId(TenantId var1, DeviceProfileId var2, PageLink var3);

    public ListenableFuture<List<Device>> findDevicesByTenantIdAndIdsAsync(TenantId var1, List<DeviceId> var2);

    public List<Device> findDevicesByIds(List<DeviceId> var1);

    public ListenableFuture<List<Device>> findDevicesByIdsAsync(List<DeviceId> var1);

    public void deleteDevicesByTenantId(TenantId var1);

    public PageData<Device> findDevicesByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<Device> findDevicesByTenantIdAndCustomerIdAndType(TenantId var1, CustomerId var2, String var3, PageLink var4);

    public void deleteDevicesByTenantIdAndCustomerId(TenantId var1, CustomerId var2);

    public ListenableFuture<List<Device>> findDevicesByTenantIdCustomerIdAndIdsAsync(TenantId var1, CustomerId var2, List<DeviceId> var3);

    public ListenableFuture<List<Device>> findDevicesByQuery(TenantId var1, DeviceSearchQuery var2);

    @Deprecated(since="3.6.2", forRemoval=true)
    public ListenableFuture<List<EntitySubtype>> findDeviceTypesByTenantId(TenantId var1);

    public PageData<Device> findDevicesByEntityGroupId(EntityGroupId var1, PageLink var2);

    public PageData<Device> findDevicesByEntityGroupIds(List<EntityGroupId> var1, PageLink var2);

    public PageData<UUID> findDevicesIdsByDeviceProfileTransportType(DeviceTransportType var1, PageLink var2);

    public PageData<Device> findDevicesByEntityGroupIdsAndType(List<EntityGroupId> var1, String var2, PageLink var3);

    public Device assignDeviceToTenant(TenantId var1, Device var2);

    public PageData<Device> findByEntityGroupAndDeviceProfileAndEmptyOtaPackage(EntityGroupId var1, DeviceProfileId var2, OtaPackageType var3, PageLink var4);

    public PageData<Device> findByDeviceProfileAndEmptyOtaPackage(TenantId var1, DeviceProfileId var2, OtaPackageType var3, PageLink var4);

    public long countByEntityGroupAndEmptyOtaPackage(EntityGroupId var1, OtaPackageId var2, OtaPackageType var3);

    public long countByDeviceProfileAndEmptyOtaPackage(TenantId var1, DeviceProfileId var2, OtaPackageType var3);
}

