/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.customer;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.CustomerInfo;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomMenuId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface CustomerService
extends EntityDaoService {
    public Customer findCustomerById(TenantId var1, CustomerId var2);

    public CustomerInfo findCustomerInfoById(TenantId var1, CustomerId var2);

    public Optional<Customer> findCustomerByTenantIdAndTitle(TenantId var1, String var2);

    public ListenableFuture<Optional<Customer>> findCustomerByTenantIdAndTitleAsync(TenantId var1, String var2);

    public ListenableFuture<Customer> findCustomerByIdAsync(TenantId var1, CustomerId var2);

    public ListenableFuture<List<Customer>> findCustomersByTenantIdAndIdsAsync(TenantId var1, List<CustomerId> var2);

    public Customer saveCustomer(Customer var1);

    public void deleteCustomer(TenantId var1, CustomerId var2);

    public Customer findOrCreatePublicCustomer(TenantId var1, EntityId var2);

    public Customer findPublicCustomer(TenantId var1, EntityId var2);

    public EntityGroup findOrCreatePublicUserGroup(TenantId var1, EntityId var2);

    public Role findOrCreatePublicUserEntityGroupRole(TenantId var1, EntityId var2);

    public PageData<Customer> findCustomersByTenantId(TenantId var1, PageLink var2);

    public void deleteCustomersByTenantId(TenantId var1);

    public PageData<Customer> findCustomersByEntityGroupId(EntityGroupId var1, PageLink var2);

    public PageData<Customer> findCustomersByEntityGroupIds(List<EntityGroupId> var1, List<CustomerId> var2, PageLink var3);

    public PageData<CustomerInfo> findCustomerInfosByTenantId(TenantId var1, PageLink var2);

    public PageData<CustomerInfo> findTenantCustomerInfosByTenantId(TenantId var1, PageLink var2);

    public PageData<CustomerInfo> findCustomerInfosByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<CustomerInfo> findCustomerInfosByTenantIdAndCustomerIdIncludingSubCustomers(TenantId var1, CustomerId var2, PageLink var3);

    public List<Customer> findCustomersByCustomMenuId(CustomMenuId var1);

    public void updateCustomersCustomMenuId(List<CustomerId> var1, CustomMenuId var2);
}

