/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.cassandra.guava;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.cql.SyncCqlSession;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.cql.DefaultPrepareRequest;
import com.datastax.oss.driver.internal.core.cql.SinglePageResultSet;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.ExecutionException;
import org.thingsboard.server.dao.cassandra.guava.GuavaMultiPageResultSet;

public interface GuavaSession
extends Session,
SyncCqlSession {
    public static final GenericType<ListenableFuture<AsyncResultSet>> ASYNC = new GenericType<ListenableFuture<AsyncResultSet>>(){};
    public static final GenericType<ListenableFuture<PreparedStatement>> ASYNC_PREPARED = new GenericType<ListenableFuture<PreparedStatement>>(){};

    @NonNull
    default public ResultSet execute(@NonNull Statement<?> statement) {
        AsyncResultSet firstPage = GuavaSession.getSafe(this.executeAsync(statement));
        if (firstPage.hasMorePages()) {
            return new GuavaMultiPageResultSet(this, statement, firstPage);
        }
        return new SinglePageResultSet(firstPage);
    }

    default public ListenableFuture<AsyncResultSet> executeAsync(Statement<?> statement) {
        return (ListenableFuture)this.execute((Request)statement, (GenericType)ASYNC);
    }

    default public ListenableFuture<AsyncResultSet> executeAsync(String statement) {
        return this.executeAsync((Statement<?>)SimpleStatement.newInstance((String)statement));
    }

    default public ListenableFuture<PreparedStatement> prepareAsync(SimpleStatement statement) {
        return (ListenableFuture)this.execute((Request)new DefaultPrepareRequest(statement), ASYNC_PREPARED);
    }

    default public ListenableFuture<PreparedStatement> prepareAsync(String statement) {
        return this.prepareAsync(SimpleStatement.newInstance((String)statement));
    }

    public static AsyncResultSet getSafe(ListenableFuture<AsyncResultSet> future) {
        try {
            return (AsyncResultSet)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }
}

