/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.cassandra.guava;

import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.CompletionStage;

public class GuavaRequestAsyncProcessor<T extends Request, U>
implements RequestProcessor<T, ListenableFuture<U>> {
    private final RequestProcessor<T, CompletionStage<U>> subProcessor;
    private final GenericType resultType;
    private final Class<?> requestClass;

    GuavaRequestAsyncProcessor(RequestProcessor<T, CompletionStage<U>> subProcessor, Class<?> requestClass, GenericType resultType) {
        this.subProcessor = subProcessor;
        this.requestClass = requestClass;
        this.resultType = resultType;
    }

    public boolean canProcess(Request request, GenericType resultType) {
        return this.requestClass.isInstance(request) && resultType.equals((Object)this.resultType);
    }

    public ListenableFuture<U> process(T request, DefaultSession session, InternalDriverContext context, String sessionLogPrefix) {
        SettableFuture future = SettableFuture.create();
        ((CompletionStage)this.subProcessor.process(request, session, context, sessionLogPrefix)).whenComplete((r, ex) -> {
            if (ex != null) {
                future.setException(ex);
            } else {
                future.set(r);
            }
        });
        return future;
    }

    public ListenableFuture<U> newFailure(RuntimeException error) {
        return Futures.immediateFailedFuture((Throwable)error);
    }
}

