/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.cassandra.guava;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.thingsboard.server.dao.cassandra.guava.GuavaSession;

public class GuavaMultiPageResultSet
implements ResultSet {
    private final RowIterator iterator;
    private final List<ExecutionInfo> executionInfos = new ArrayList<ExecutionInfo>();
    private ColumnDefinitions columnDefinitions;

    public GuavaMultiPageResultSet(@NonNull GuavaSession session, @NonNull Statement statement, @NonNull AsyncResultSet firstPage) {
        assert (firstPage.hasMorePages());
        this.iterator = new RowIterator(session, statement, firstPage);
        this.executionInfos.add(firstPage.getExecutionInfo());
        this.columnDefinitions = firstPage.getColumnDefinitions();
    }

    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @NonNull
    public List<ExecutionInfo> getExecutionInfos() {
        return this.executionInfos;
    }

    public boolean isFullyFetched() {
        return this.iterator.isFullyFetched();
    }

    public int getAvailableWithoutFetching() {
        return this.iterator.remaining();
    }

    @NonNull
    public Iterator<Row> iterator() {
        return this.iterator;
    }

    public boolean wasApplied() {
        return this.iterator.wasApplied();
    }

    private class RowIterator
    extends CountingIterator<Row> {
        private GuavaSession session;
        private Statement statement;
        private AsyncResultSet currentPage;
        private Iterator<Row> currentRows;

        private RowIterator(GuavaSession session, Statement statement, AsyncResultSet firstPage) {
            super(firstPage.remaining());
            this.session = session;
            this.statement = statement;
            this.currentPage = firstPage;
            this.currentRows = firstPage.currentPage().iterator();
        }

        protected Row computeNext() {
            this.maybeMoveToNextPage();
            return this.currentRows.hasNext() ? this.currentRows.next() : (Row)this.endOfData();
        }

        private void maybeMoveToNextPage() {
            if (!this.currentRows.hasNext() && this.currentPage.hasMorePages()) {
                AsyncResultSet nextPage;
                BlockingOperation.checkNotDriverThread();
                ByteBuffer nextPagingState = this.currentPage.getExecutionInfo().getPagingState();
                this.statement = this.statement.setPagingState(nextPagingState);
                this.currentPage = nextPage = GuavaSession.getSafe(this.session.executeAsync(this.statement));
                this.remaining += nextPage.remaining();
                this.currentRows = nextPage.currentPage().iterator();
                GuavaMultiPageResultSet.this.executionInfos.add(nextPage.getExecutionInfo());
                GuavaMultiPageResultSet.this.columnDefinitions = nextPage.getColumnDefinitions();
            }
        }

        private boolean isFullyFetched() {
            return !this.currentPage.hasMorePages();
        }

        private boolean wasApplied() {
            return this.currentPage.wasApplied();
        }
    }
}

