/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.dao.util.NoSqlAnyDao;

@Component
@Configuration
@NoSqlAnyDao
public class CassandraDriverOptions {
    private static final String COMMA = ",";
    @Value(value="${cassandra.cluster_name}")
    private String clusterName;
    @Value(value="${cassandra.url}")
    private String url;
    @Value(value="${cassandra.socket.connect_timeout}")
    private int connectTimeoutMillis;
    @Value(value="${cassandra.socket.read_timeout}")
    private int readTimeoutMillis;
    @Value(value="${cassandra.socket.keep_alive}")
    private Boolean keepAlive;
    @Value(value="${cassandra.socket.reuse_address}")
    private Boolean reuseAddress;
    @Value(value="${cassandra.socket.so_linger}")
    private Integer soLinger;
    @Value(value="${cassandra.socket.tcp_no_delay}")
    private Boolean tcpNoDelay;
    @Value(value="${cassandra.socket.receive_buffer_size}")
    private Integer receiveBufferSize;
    @Value(value="${cassandra.socket.send_buffer_size}")
    private Integer sendBufferSize;
    @Value(value="${cassandra.max_requests_per_connection_local:32768}")
    private int max_requests_local;
    @Value(value="${cassandra.max_requests_per_connection_remote:32768}")
    private int max_requests_remote;
    @Value(value="${cassandra.query.default_fetch_size}")
    private Integer defaultFetchSize;
    @Value(value="${cassandra.query.read_consistency_level}")
    private String readConsistencyLevel;
    @Value(value="${cassandra.query.write_consistency_level}")
    private String writeConsistencyLevel;
    @Value(value="${cassandra.compression}")
    private String compression;
    @Value(value="${cassandra.ssl.enabled}")
    private Boolean ssl;
    @Value(value="${cassandra.ssl.key_store}")
    private String sslKeyStore;
    @Value(value="${cassandra.ssl.key_store_password}")
    private String sslKeyStorePassword;
    @Value(value="${cassandra.ssl.trust_store}")
    private String sslTrustStore;
    @Value(value="${cassandra.ssl.trust_store_password}")
    private String sslTrustStorePassword;
    @Value(value="${cassandra.ssl.hostname_validation}")
    private Boolean sslHostnameValidation;
    @Value(value="${cassandra.ssl.cipher_suites}")
    private List<String> sslCipherSuites;
    @Value(value="${cassandra.metrics}")
    private Boolean metrics;
    @Value(value="${cassandra.credentials}")
    private Boolean credentials;
    @Value(value="${cassandra.username}")
    private String username;
    @Value(value="${cassandra.password}")
    private String password;
    @Value(value="${cassandra.init_timeout_ms}")
    private long initTimeout;
    @Value(value="${cassandra.init_retry_interval_ms}")
    private long initRetryInterval;
    private DriverConfigLoader loader;
    private ConsistencyLevel defaultReadConsistencyLevel;
    private ConsistencyLevel defaultWriteConsistencyLevel;

    @PostConstruct
    public void initLoader() {
        ProgrammaticDriverConfigLoaderBuilder driverConfigBuilder = DriverConfigLoader.programmaticBuilder();
        ((ProgrammaticDriverConfigLoaderBuilder)driverConfigBuilder.withStringList((DriverOption)DefaultDriverOption.CONTACT_POINTS, this.getContactPoints(this.url))).withString((DriverOption)DefaultDriverOption.SESSION_NAME, this.clusterName);
        this.initSocketOptions(driverConfigBuilder);
        this.initPoolingOptions(driverConfigBuilder);
        this.initQueryOptions(driverConfigBuilder);
        driverConfigBuilder.withString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, StringUtils.isEmpty((String)this.compression) ? "none" : this.compression.toLowerCase());
        if (this.ssl.booleanValue()) {
            ((ProgrammaticDriverConfigLoaderBuilder)driverConfigBuilder.withString((DriverOption)DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS, "DefaultSslEngineFactory")).withBoolean((DriverOption)DefaultDriverOption.SSL_HOSTNAME_VALIDATION, this.sslHostnameValidation.booleanValue());
            if (!this.sslTrustStore.isEmpty()) {
                ((ProgrammaticDriverConfigLoaderBuilder)driverConfigBuilder.withString((DriverOption)DefaultDriverOption.SSL_TRUSTSTORE_PATH, this.sslTrustStore)).withString((DriverOption)DefaultDriverOption.SSL_TRUSTSTORE_PASSWORD, this.sslTrustStorePassword);
            }
            if (!this.sslKeyStore.isEmpty()) {
                ((ProgrammaticDriverConfigLoaderBuilder)driverConfigBuilder.withString((DriverOption)DefaultDriverOption.SSL_KEYSTORE_PATH, this.sslKeyStore)).withString((DriverOption)DefaultDriverOption.SSL_KEYSTORE_PASSWORD, this.sslKeyStorePassword);
            }
            if (!this.sslCipherSuites.isEmpty()) {
                driverConfigBuilder.withStringList((DriverOption)DefaultDriverOption.SSL_CIPHER_SUITES, this.sslCipherSuites);
            }
        }
        if (this.metrics.booleanValue()) {
            driverConfigBuilder.withStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED, Arrays.asList(DefaultSessionMetric.CONNECTED_NODES.getPath(), DefaultSessionMetric.CQL_REQUESTS.getPath()));
            driverConfigBuilder.withStringList((DriverOption)DefaultDriverOption.METRICS_NODE_ENABLED, Arrays.asList(DefaultNodeMetric.OPEN_CONNECTIONS.getPath(), DefaultNodeMetric.IN_FLIGHT.getPath()));
        }
        if (this.credentials.booleanValue()) {
            driverConfigBuilder.withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_CLASS, "PlainTextAuthProvider");
            driverConfigBuilder.withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME, this.username);
            driverConfigBuilder.withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_PASSWORD, this.password);
        }
        driverConfigBuilder.withBoolean((DriverOption)DefaultDriverOption.RECONNECT_ON_INIT, true);
        driverConfigBuilder.withString((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, "ExponentialReconnectionPolicy");
        driverConfigBuilder.withDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY, Duration.ofMillis(this.initRetryInterval));
        driverConfigBuilder.withDuration((DriverOption)DefaultDriverOption.RECONNECTION_MAX_DELAY, Duration.ofMillis(this.initTimeout));
        this.loader = driverConfigBuilder.build();
    }

    protected ConsistencyLevel getDefaultReadConsistencyLevel() {
        if (this.defaultReadConsistencyLevel == null) {
            this.defaultReadConsistencyLevel = this.readConsistencyLevel != null ? DefaultConsistencyLevel.valueOf((String)this.readConsistencyLevel.toUpperCase()) : DefaultConsistencyLevel.ONE;
        }
        return this.defaultReadConsistencyLevel;
    }

    protected ConsistencyLevel getDefaultWriteConsistencyLevel() {
        if (this.defaultWriteConsistencyLevel == null) {
            this.defaultWriteConsistencyLevel = this.writeConsistencyLevel != null ? DefaultConsistencyLevel.valueOf((String)this.writeConsistencyLevel.toUpperCase()) : DefaultConsistencyLevel.ONE;
        }
        return this.defaultWriteConsistencyLevel;
    }

    private void initSocketOptions(ProgrammaticDriverConfigLoaderBuilder driverConfigBuilder) {
        driverConfigBuilder.withDuration((DriverOption)DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT, Duration.ofMillis(this.connectTimeoutMillis));
        driverConfigBuilder.withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofMillis(this.readTimeoutMillis));
        if (this.keepAlive != null) {
            driverConfigBuilder.withBoolean((DriverOption)DefaultDriverOption.SOCKET_KEEP_ALIVE, this.keepAlive.booleanValue());
        }
        if (this.reuseAddress != null) {
            driverConfigBuilder.withBoolean((DriverOption)DefaultDriverOption.SOCKET_REUSE_ADDRESS, this.reuseAddress.booleanValue());
        }
        if (this.soLinger != null) {
            driverConfigBuilder.withInt((DriverOption)DefaultDriverOption.SOCKET_LINGER_INTERVAL, this.soLinger.intValue());
        }
        if (this.tcpNoDelay != null) {
            driverConfigBuilder.withBoolean((DriverOption)DefaultDriverOption.SOCKET_TCP_NODELAY, this.tcpNoDelay.booleanValue());
        }
        if (this.receiveBufferSize != null) {
            driverConfigBuilder.withInt((DriverOption)DefaultDriverOption.SOCKET_RECEIVE_BUFFER_SIZE, this.receiveBufferSize.intValue());
        }
        if (this.sendBufferSize != null) {
            driverConfigBuilder.withInt((DriverOption)DefaultDriverOption.SOCKET_SEND_BUFFER_SIZE, this.sendBufferSize.intValue());
        }
    }

    private void initPoolingOptions(ProgrammaticDriverConfigLoaderBuilder driverConfigBuilder) {
        driverConfigBuilder.withInt((DriverOption)DefaultDriverOption.CONNECTION_MAX_REQUESTS, this.max_requests_local);
    }

    private void initQueryOptions(ProgrammaticDriverConfigLoaderBuilder driverConfigBuilder) {
        driverConfigBuilder.withInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, this.defaultFetchSize.intValue());
    }

    private List<String> getContactPoints(String url) {
        List<String> result;
        if (StringUtils.isBlank((String)url)) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            for (String hostPort : url.split(COMMA)) {
                result.add(hostPort);
            }
        }
        return result;
    }

    @Generated
    public CassandraDriverOptions() {
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Generated
    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Generated
    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    @Generated
    public Boolean getReuseAddress() {
        return this.reuseAddress;
    }

    @Generated
    public Integer getSoLinger() {
        return this.soLinger;
    }

    @Generated
    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Generated
    public Integer getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Generated
    public Integer getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Generated
    public int getMax_requests_local() {
        return this.max_requests_local;
    }

    @Generated
    public int getMax_requests_remote() {
        return this.max_requests_remote;
    }

    @Generated
    public Integer getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Generated
    public String getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    @Generated
    public String getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    @Generated
    public String getCompression() {
        return this.compression;
    }

    @Generated
    public Boolean getSsl() {
        return this.ssl;
    }

    @Generated
    public String getSslKeyStore() {
        return this.sslKeyStore;
    }

    @Generated
    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    @Generated
    public String getSslTrustStore() {
        return this.sslTrustStore;
    }

    @Generated
    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    @Generated
    public Boolean getSslHostnameValidation() {
        return this.sslHostnameValidation;
    }

    @Generated
    public List<String> getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    @Generated
    public Boolean getMetrics() {
        return this.metrics;
    }

    @Generated
    public Boolean getCredentials() {
        return this.credentials;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public long getInitTimeout() {
        return this.initTimeout;
    }

    @Generated
    public long getInitRetryInterval() {
        return this.initRetryInterval;
    }

    @Generated
    public DriverConfigLoader getLoader() {
        return this.loader;
    }

    @Generated
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    @Generated
    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Generated
    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Generated
    public void setReuseAddress(Boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @Generated
    public void setSoLinger(Integer soLinger) {
        this.soLinger = soLinger;
    }

    @Generated
    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    @Generated
    public void setReceiveBufferSize(Integer receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    @Generated
    public void setSendBufferSize(Integer sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    @Generated
    public void setMax_requests_local(int max_requests_local) {
        this.max_requests_local = max_requests_local;
    }

    @Generated
    public void setMax_requests_remote(int max_requests_remote) {
        this.max_requests_remote = max_requests_remote;
    }

    @Generated
    public void setDefaultFetchSize(Integer defaultFetchSize) {
        this.defaultFetchSize = defaultFetchSize;
    }

    @Generated
    public void setReadConsistencyLevel(String readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    @Generated
    public void setWriteConsistencyLevel(String writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    @Generated
    public void setCompression(String compression) {
        this.compression = compression;
    }

    @Generated
    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    @Generated
    public void setSslKeyStore(String sslKeyStore) {
        this.sslKeyStore = sslKeyStore;
    }

    @Generated
    public void setSslKeyStorePassword(String sslKeyStorePassword) {
        this.sslKeyStorePassword = sslKeyStorePassword;
    }

    @Generated
    public void setSslTrustStore(String sslTrustStore) {
        this.sslTrustStore = sslTrustStore;
    }

    @Generated
    public void setSslTrustStorePassword(String sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
    }

    @Generated
    public void setSslHostnameValidation(Boolean sslHostnameValidation) {
        this.sslHostnameValidation = sslHostnameValidation;
    }

    @Generated
    public void setSslCipherSuites(List<String> sslCipherSuites) {
        this.sslCipherSuites = sslCipherSuites;
    }

    @Generated
    public void setMetrics(Boolean metrics) {
        this.metrics = metrics;
    }

    @Generated
    public void setCredentials(Boolean credentials) {
        this.credentials = credentials;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setInitTimeout(long initTimeout) {
        this.initTimeout = initTimeout;
    }

    @Generated
    public void setInitRetryInterval(long initRetryInterval) {
        this.initRetryInterval = initRetryInterval;
    }

    @Generated
    public void setLoader(DriverConfigLoader loader) {
        this.loader = loader;
    }

    @Generated
    public void setDefaultReadConsistencyLevel(ConsistencyLevel defaultReadConsistencyLevel) {
        this.defaultReadConsistencyLevel = defaultReadConsistencyLevel;
    }

    @Generated
    public void setDefaultWriteConsistencyLevel(ConsistencyLevel defaultWriteConsistencyLevel) {
        this.defaultWriteConsistencyLevel = defaultWriteConsistencyLevel;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraDriverOptions)) {
            return false;
        }
        CassandraDriverOptions other = (CassandraDriverOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeoutMillis() != other.getConnectTimeoutMillis()) {
            return false;
        }
        if (this.getReadTimeoutMillis() != other.getReadTimeoutMillis()) {
            return false;
        }
        if (this.getMax_requests_local() != other.getMax_requests_local()) {
            return false;
        }
        if (this.getMax_requests_remote() != other.getMax_requests_remote()) {
            return false;
        }
        if (this.getInitTimeout() != other.getInitTimeout()) {
            return false;
        }
        if (this.getInitRetryInterval() != other.getInitRetryInterval()) {
            return false;
        }
        Boolean this$keepAlive = this.getKeepAlive();
        Boolean other$keepAlive = other.getKeepAlive();
        if (this$keepAlive == null ? other$keepAlive != null : !((Object)this$keepAlive).equals(other$keepAlive)) {
            return false;
        }
        Boolean this$reuseAddress = this.getReuseAddress();
        Boolean other$reuseAddress = other.getReuseAddress();
        if (this$reuseAddress == null ? other$reuseAddress != null : !((Object)this$reuseAddress).equals(other$reuseAddress)) {
            return false;
        }
        Integer this$soLinger = this.getSoLinger();
        Integer other$soLinger = other.getSoLinger();
        if (this$soLinger == null ? other$soLinger != null : !((Object)this$soLinger).equals(other$soLinger)) {
            return false;
        }
        Boolean this$tcpNoDelay = this.getTcpNoDelay();
        Boolean other$tcpNoDelay = other.getTcpNoDelay();
        if (this$tcpNoDelay == null ? other$tcpNoDelay != null : !((Object)this$tcpNoDelay).equals(other$tcpNoDelay)) {
            return false;
        }
        Integer this$receiveBufferSize = this.getReceiveBufferSize();
        Integer other$receiveBufferSize = other.getReceiveBufferSize();
        if (this$receiveBufferSize == null ? other$receiveBufferSize != null : !((Object)this$receiveBufferSize).equals(other$receiveBufferSize)) {
            return false;
        }
        Integer this$sendBufferSize = this.getSendBufferSize();
        Integer other$sendBufferSize = other.getSendBufferSize();
        if (this$sendBufferSize == null ? other$sendBufferSize != null : !((Object)this$sendBufferSize).equals(other$sendBufferSize)) {
            return false;
        }
        Integer this$defaultFetchSize = this.getDefaultFetchSize();
        Integer other$defaultFetchSize = other.getDefaultFetchSize();
        if (this$defaultFetchSize == null ? other$defaultFetchSize != null : !((Object)this$defaultFetchSize).equals(other$defaultFetchSize)) {
            return false;
        }
        Boolean this$ssl = this.getSsl();
        Boolean other$ssl = other.getSsl();
        if (this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl)) {
            return false;
        }
        Boolean this$sslHostnameValidation = this.getSslHostnameValidation();
        Boolean other$sslHostnameValidation = other.getSslHostnameValidation();
        if (this$sslHostnameValidation == null ? other$sslHostnameValidation != null : !((Object)this$sslHostnameValidation).equals(other$sslHostnameValidation)) {
            return false;
        }
        Boolean this$metrics = this.getMetrics();
        Boolean other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        Boolean this$credentials = this.getCredentials();
        Boolean other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$readConsistencyLevel = this.getReadConsistencyLevel();
        String other$readConsistencyLevel = other.getReadConsistencyLevel();
        if (this$readConsistencyLevel == null ? other$readConsistencyLevel != null : !this$readConsistencyLevel.equals(other$readConsistencyLevel)) {
            return false;
        }
        String this$writeConsistencyLevel = this.getWriteConsistencyLevel();
        String other$writeConsistencyLevel = other.getWriteConsistencyLevel();
        if (this$writeConsistencyLevel == null ? other$writeConsistencyLevel != null : !this$writeConsistencyLevel.equals(other$writeConsistencyLevel)) {
            return false;
        }
        String this$compression = this.getCompression();
        String other$compression = other.getCompression();
        if (this$compression == null ? other$compression != null : !this$compression.equals(other$compression)) {
            return false;
        }
        String this$sslKeyStore = this.getSslKeyStore();
        String other$sslKeyStore = other.getSslKeyStore();
        if (this$sslKeyStore == null ? other$sslKeyStore != null : !this$sslKeyStore.equals(other$sslKeyStore)) {
            return false;
        }
        String this$sslKeyStorePassword = this.getSslKeyStorePassword();
        String other$sslKeyStorePassword = other.getSslKeyStorePassword();
        if (this$sslKeyStorePassword == null ? other$sslKeyStorePassword != null : !this$sslKeyStorePassword.equals(other$sslKeyStorePassword)) {
            return false;
        }
        String this$sslTrustStore = this.getSslTrustStore();
        String other$sslTrustStore = other.getSslTrustStore();
        if (this$sslTrustStore == null ? other$sslTrustStore != null : !this$sslTrustStore.equals(other$sslTrustStore)) {
            return false;
        }
        String this$sslTrustStorePassword = this.getSslTrustStorePassword();
        String other$sslTrustStorePassword = other.getSslTrustStorePassword();
        if (this$sslTrustStorePassword == null ? other$sslTrustStorePassword != null : !this$sslTrustStorePassword.equals(other$sslTrustStorePassword)) {
            return false;
        }
        List<String> this$sslCipherSuites = this.getSslCipherSuites();
        List<String> other$sslCipherSuites = other.getSslCipherSuites();
        if (this$sslCipherSuites == null ? other$sslCipherSuites != null : !((Object)this$sslCipherSuites).equals(other$sslCipherSuites)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        DriverConfigLoader this$loader = this.getLoader();
        DriverConfigLoader other$loader = other.getLoader();
        if (this$loader == null ? other$loader != null : !this$loader.equals(other$loader)) {
            return false;
        }
        ConsistencyLevel this$defaultReadConsistencyLevel = this.getDefaultReadConsistencyLevel();
        ConsistencyLevel other$defaultReadConsistencyLevel = other.getDefaultReadConsistencyLevel();
        if (this$defaultReadConsistencyLevel == null ? other$defaultReadConsistencyLevel != null : !this$defaultReadConsistencyLevel.equals(other$defaultReadConsistencyLevel)) {
            return false;
        }
        ConsistencyLevel this$defaultWriteConsistencyLevel = this.getDefaultWriteConsistencyLevel();
        ConsistencyLevel other$defaultWriteConsistencyLevel = other.getDefaultWriteConsistencyLevel();
        return !(this$defaultWriteConsistencyLevel == null ? other$defaultWriteConsistencyLevel != null : !this$defaultWriteConsistencyLevel.equals(other$defaultWriteConsistencyLevel));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CassandraDriverOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectTimeoutMillis();
        result = result * 59 + this.getReadTimeoutMillis();
        result = result * 59 + this.getMax_requests_local();
        result = result * 59 + this.getMax_requests_remote();
        long $initTimeout = this.getInitTimeout();
        result = result * 59 + (int)($initTimeout >>> 32 ^ $initTimeout);
        long $initRetryInterval = this.getInitRetryInterval();
        result = result * 59 + (int)($initRetryInterval >>> 32 ^ $initRetryInterval);
        Boolean $keepAlive = this.getKeepAlive();
        result = result * 59 + ($keepAlive == null ? 43 : ((Object)$keepAlive).hashCode());
        Boolean $reuseAddress = this.getReuseAddress();
        result = result * 59 + ($reuseAddress == null ? 43 : ((Object)$reuseAddress).hashCode());
        Integer $soLinger = this.getSoLinger();
        result = result * 59 + ($soLinger == null ? 43 : ((Object)$soLinger).hashCode());
        Boolean $tcpNoDelay = this.getTcpNoDelay();
        result = result * 59 + ($tcpNoDelay == null ? 43 : ((Object)$tcpNoDelay).hashCode());
        Integer $receiveBufferSize = this.getReceiveBufferSize();
        result = result * 59 + ($receiveBufferSize == null ? 43 : ((Object)$receiveBufferSize).hashCode());
        Integer $sendBufferSize = this.getSendBufferSize();
        result = result * 59 + ($sendBufferSize == null ? 43 : ((Object)$sendBufferSize).hashCode());
        Integer $defaultFetchSize = this.getDefaultFetchSize();
        result = result * 59 + ($defaultFetchSize == null ? 43 : ((Object)$defaultFetchSize).hashCode());
        Boolean $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
        Boolean $sslHostnameValidation = this.getSslHostnameValidation();
        result = result * 59 + ($sslHostnameValidation == null ? 43 : ((Object)$sslHostnameValidation).hashCode());
        Boolean $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        Boolean $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $readConsistencyLevel = this.getReadConsistencyLevel();
        result = result * 59 + ($readConsistencyLevel == null ? 43 : $readConsistencyLevel.hashCode());
        String $writeConsistencyLevel = this.getWriteConsistencyLevel();
        result = result * 59 + ($writeConsistencyLevel == null ? 43 : $writeConsistencyLevel.hashCode());
        String $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : $compression.hashCode());
        String $sslKeyStore = this.getSslKeyStore();
        result = result * 59 + ($sslKeyStore == null ? 43 : $sslKeyStore.hashCode());
        String $sslKeyStorePassword = this.getSslKeyStorePassword();
        result = result * 59 + ($sslKeyStorePassword == null ? 43 : $sslKeyStorePassword.hashCode());
        String $sslTrustStore = this.getSslTrustStore();
        result = result * 59 + ($sslTrustStore == null ? 43 : $sslTrustStore.hashCode());
        String $sslTrustStorePassword = this.getSslTrustStorePassword();
        result = result * 59 + ($sslTrustStorePassword == null ? 43 : $sslTrustStorePassword.hashCode());
        List<String> $sslCipherSuites = this.getSslCipherSuites();
        result = result * 59 + ($sslCipherSuites == null ? 43 : ((Object)$sslCipherSuites).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        DriverConfigLoader $loader = this.getLoader();
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        ConsistencyLevel $defaultReadConsistencyLevel = this.getDefaultReadConsistencyLevel();
        result = result * 59 + ($defaultReadConsistencyLevel == null ? 43 : $defaultReadConsistencyLevel.hashCode());
        ConsistencyLevel $defaultWriteConsistencyLevel = this.getDefaultWriteConsistencyLevel();
        result = result * 59 + ($defaultWriteConsistencyLevel == null ? 43 : $defaultWriteConsistencyLevel.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CassandraDriverOptions(clusterName=" + this.getClusterName() + ", url=" + this.getUrl() + ", connectTimeoutMillis=" + this.getConnectTimeoutMillis() + ", readTimeoutMillis=" + this.getReadTimeoutMillis() + ", keepAlive=" + this.getKeepAlive() + ", reuseAddress=" + this.getReuseAddress() + ", soLinger=" + this.getSoLinger() + ", tcpNoDelay=" + this.getTcpNoDelay() + ", receiveBufferSize=" + this.getReceiveBufferSize() + ", sendBufferSize=" + this.getSendBufferSize() + ", max_requests_local=" + this.getMax_requests_local() + ", max_requests_remote=" + this.getMax_requests_remote() + ", defaultFetchSize=" + this.getDefaultFetchSize() + ", readConsistencyLevel=" + this.getReadConsistencyLevel() + ", writeConsistencyLevel=" + this.getWriteConsistencyLevel() + ", compression=" + this.getCompression() + ", ssl=" + this.getSsl() + ", sslKeyStore=" + this.getSslKeyStore() + ", sslKeyStorePassword=" + this.getSslKeyStorePassword() + ", sslTrustStore=" + this.getSslTrustStore() + ", sslTrustStorePassword=" + this.getSslTrustStorePassword() + ", sslHostnameValidation=" + this.getSslHostnameValidation() + ", sslCipherSuites=" + String.valueOf(this.getSslCipherSuites()) + ", metrics=" + this.getMetrics() + ", credentials=" + this.getCredentials() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", initTimeout=" + this.getInitTimeout() + ", initRetryInterval=" + this.getInitRetryInterval() + ", loader=" + String.valueOf(this.getLoader()) + ", defaultReadConsistencyLevel=" + String.valueOf(this.getDefaultReadConsistencyLevel()) + ", defaultWriteConsistencyLevel=" + String.valueOf(this.getDefaultWriteConsistencyLevel()) + ")";
    }
}

