/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.asset;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.ProfileEntityIdInfo;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetInfo;
import org.thingsboard.server.common.data.asset.AssetSearchQuery;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface AssetService
extends EntityDaoService {
    public Asset findAssetById(TenantId var1, AssetId var2);

    public AssetInfo findAssetInfoById(TenantId var1, AssetId var2);

    public EntityInfo findAssetEntityInfoById(TenantId var1, AssetId var2);

    public ListenableFuture<Asset> findAssetByIdAsync(TenantId var1, AssetId var2);

    public Asset findAssetByTenantIdAndName(TenantId var1, String var2);

    public ListenableFuture<Asset> findAssetByTenantIdAndNameAsync(TenantId var1, String var2);

    public Asset saveAsset(Asset var1, boolean var2);

    public Asset saveAsset(Asset var1);

    public void deleteAsset(TenantId var1, AssetId var2);

    public PageData<Asset> findAssetsByTenantId(TenantId var1, PageLink var2);

    public Long countAssets();

    public PageData<Asset> findAssetsByTenantIdAndType(TenantId var1, String var2, PageLink var3);

    public PageData<ProfileEntityIdInfo> findProfileEntityIdInfos(PageLink var1);

    public PageData<ProfileEntityIdInfo> findProfileEntityIdInfosByTenantId(TenantId var1, PageLink var2);

    public PageData<AssetId> findAssetIdsByTenantIdAndAssetProfileId(TenantId var1, AssetProfileId var2, PageLink var3);

    public PageData<EntityInfo> findAssetEntityInfosByTenantIdAndAssetProfileId(TenantId var1, AssetProfileId var2, PageLink var3);

    public ListenableFuture<List<Asset>> findAssetsByTenantIdAndIdsAsync(TenantId var1, List<AssetId> var2);

    public void deleteAssetsByTenantId(TenantId var1);

    public PageData<Asset> findAssetsByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<Asset> findAssetsByTenantIdAndCustomerIdAndType(TenantId var1, CustomerId var2, String var3, PageLink var4);

    public void deleteAssetsByTenantIdAndCustomerId(TenantId var1, CustomerId var2);

    public ListenableFuture<List<Asset>> findAssetsByTenantIdCustomerIdAndIdsAsync(TenantId var1, CustomerId var2, List<AssetId> var3);

    public ListenableFuture<List<Asset>> findAssetsByQuery(TenantId var1, AssetSearchQuery var2);

    @Deprecated(since="3.6.2", forRemoval=true)
    public ListenableFuture<List<EntitySubtype>> findAssetTypesByTenantId(TenantId var1);

    public PageData<Asset> findAssetsByEntityGroupId(EntityGroupId var1, PageLink var2);

    public PageData<Asset> findAssetsByEntityGroupIds(List<EntityGroupId> var1, PageLink var2);

    public PageData<Asset> findAssetsByEntityGroupIdsAndType(List<EntityGroupId> var1, String var2, PageLink var3);

    public PageData<AssetInfo> findAssetInfosByTenantId(TenantId var1, PageLink var2);

    public PageData<AssetInfo> findAssetInfosByTenantIdAndAssetProfileId(TenantId var1, AssetProfileId var2, PageLink var3);

    public PageData<AssetInfo> findTenantAssetInfosByTenantId(TenantId var1, PageLink var2);

    public PageData<AssetInfo> findTenantAssetInfosByTenantIdAndAssetProfileId(TenantId var1, AssetProfileId var2, PageLink var3);

    public PageData<AssetInfo> findAssetInfosByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<AssetInfo> findAssetInfosByTenantIdAndCustomerIdAndAssetProfileId(TenantId var1, CustomerId var2, AssetProfileId var3, PageLink var4);

    public PageData<AssetInfo> findAssetInfosByTenantIdAndCustomerIdIncludingSubCustomers(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<AssetInfo> findAssetInfosByTenantIdAndCustomerIdAndAssetProfileIdIncludingSubCustomers(TenantId var1, CustomerId var2, AssetProfileId var3, PageLink var4);
}

