/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmFilter;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.alarm.AlarmQueryV2;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.alarm.AlarmUpdateRequest;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.query.AlarmCountQuery;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.common.data.query.AlarmDataQuery;
import org.thingsboard.server.common.data.query.OriginatorAlarmFilter;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface AlarmService
extends EntityDaoService {
    public AlarmApiCallResult createAlarm(AlarmCreateOrUpdateActiveRequest var1);

    public AlarmApiCallResult createAlarm(AlarmCreateOrUpdateActiveRequest var1, boolean var2);

    public AlarmApiCallResult updateAlarm(AlarmUpdateRequest var1);

    public AlarmApiCallResult acknowledgeAlarm(TenantId var1, AlarmId var2, long var3);

    public AlarmApiCallResult clearAlarm(TenantId var1, AlarmId var2, long var3, JsonNode var5);

    public AlarmApiCallResult assignAlarm(TenantId var1, AlarmId var2, UserId var3, long var4);

    public AlarmApiCallResult unassignAlarm(TenantId var1, AlarmId var2, long var3);

    public AlarmApiCallResult delAlarm(TenantId var1, AlarmId var2);

    public AlarmApiCallResult delAlarm(TenantId var1, AlarmId var2, boolean var3);

    public void delAlarmTypes(TenantId var1, Set<String> var2);

    public Alarm findAlarmById(TenantId var1, AlarmId var2);

    public ListenableFuture<Alarm> findAlarmByIdAsync(TenantId var1, AlarmId var2);

    public AlarmInfo findAlarmInfoById(TenantId var1, AlarmId var2);

    public PageData<AlarmInfo> findAlarms(TenantId var1, AlarmQuery var2);

    public PageData<AlarmInfo> findCustomerAlarms(TenantId var1, CustomerId var2, AlarmQuery var3);

    public PageData<AlarmInfo> findAlarmsV2(TenantId var1, AlarmQueryV2 var2);

    public PageData<AlarmInfo> findCustomerAlarmsV2(TenantId var1, CustomerId var2, AlarmQueryV2 var3);

    public List<Long> findAlarmCounts(TenantId var1, AlarmQuery var2, List<AlarmFilter> var3);

    public AlarmSeverity findHighestAlarmSeverity(TenantId var1, EntityId var2, AlarmSearchStatus var3, AlarmStatus var4, String var5);

    public Alarm findLatestActiveByOriginatorAndType(TenantId var1, EntityId var2, String var3);

    public FluentFuture<Alarm> findLatestActiveByOriginatorAndTypeAsync(TenantId var1, EntityId var2, String var3);

    public PageData<AlarmData> findAlarmDataByQueryForEntities(TenantId var1, MergedUserPermissions var2, AlarmDataQuery var3, Collection<EntityId> var4);

    public Set<EntityId> getPropagationEntityIds(Alarm var1);

    public Set<EntityId> getPropagationEntityIds(Alarm var1, List<EntityType> var2);

    public List<TbPair<UUID, Long>> findAlarmIdsByAssigneeId(TenantId var1, UserId var2, long var3, AlarmId var5, int var6);

    public List<TbPair<UUID, Long>> findAlarmIdsByOriginatorId(TenantId var1, EntityId var2, long var3, AlarmId var5, int var6);

    public int deleteEntityAlarmRecords(TenantId var1, EntityId var2);

    public void deleteEntityAlarmRecordsByTenantId(TenantId var1);

    public long countAlarmsByQuery(TenantId var1, CustomerId var2, MergedUserPermissions var3, AlarmCountQuery var4);

    public long countAlarmsByQuery(TenantId var1, CustomerId var2, MergedUserPermissions var3, AlarmCountQuery var4, Collection<EntityId> var5);

    public PageData<EntitySubtype> findAlarmTypesByTenantId(TenantId var1, PageLink var2);

    public List<UUID> findActiveOriginatorAlarms(TenantId var1, OriginatorAlarmFilter var2, int var3);
}

