/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.ota;

import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.ChecksumAlgorithm;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface OtaPackageService
extends EntityDaoService {
    public OtaPackageInfo saveOtaPackageInfo(OtaPackageInfo var1, boolean var2);

    public OtaPackage saveOtaPackage(OtaPackage var1);

    public String generateChecksum(ChecksumAlgorithm var1, ByteBuffer var2);

    public OtaPackage findOtaPackageById(TenantId var1, OtaPackageId var2);

    public OtaPackageInfo findOtaPackageInfoById(TenantId var1, OtaPackageId var2);

    public ListenableFuture<OtaPackageInfo> findOtaPackageInfoByIdAsync(TenantId var1, OtaPackageId var2);

    public PageData<OtaPackageInfo> findTenantOtaPackagesByTenantId(TenantId var1, PageLink var2);

    public PageData<OtaPackageInfo> findTenantOtaPackagesByTenantIdAndDeviceProfileIdAndTypeAndHasData(TenantId var1, DeviceProfileId var2, OtaPackageType var3, PageLink var4);

    public void deleteOtaPackage(TenantId var1, OtaPackageId var2);

    public void deleteOtaPackagesByTenantId(TenantId var1);

    public long sumDataSizeByTenantId(TenantId var1);
}

