/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.edge;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeInfo;
import org.thingsboard.server.common.data.edge.EdgeSearchQuery;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface EdgeService
extends EntityDaoService {
    public Edge findEdgeById(TenantId var1, EdgeId var2);

    public EdgeInfo findEdgeInfoById(TenantId var1, EdgeId var2);

    public ListenableFuture<Edge> findEdgeByIdAsync(TenantId var1, EdgeId var2);

    public Edge findEdgeByTenantIdAndName(TenantId var1, String var2);

    public Optional<Edge> findEdgeByRoutingKey(TenantId var1, String var2);

    public Edge saveEdge(Edge var1);

    public Edge assignEdgeToCustomer(TenantId var1, EdgeId var2, CustomerId var3);

    public Edge unassignEdgeFromCustomer(TenantId var1, EdgeId var2);

    public void deleteEdge(TenantId var1, EdgeId var2);

    public PageData<Edge> findEdgesByTenantId(TenantId var1, PageLink var2);

    public PageData<Edge> findEdgesByTenantIdAndType(TenantId var1, String var2, PageLink var3);

    public PageData<EdgeInfo> findEdgeInfosByTenantIdAndType(TenantId var1, String var2, PageLink var3);

    public PageData<EdgeInfo> findEdgeInfosByTenantId(TenantId var1, PageLink var2);

    public ListenableFuture<List<Edge>> findEdgesByTenantIdAndIdsAsync(TenantId var1, List<EdgeId> var2);

    public void deleteEdgesByTenantId(TenantId var1);

    public PageData<Edge> findEdgesByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<Edge> findEdgesByTenantIdAndCustomerIdAndType(TenantId var1, CustomerId var2, String var3, PageLink var4);

    public PageData<EdgeInfo> findEdgeInfosByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<EdgeInfo> findEdgeInfosByTenantIdAndCustomerIdAndType(TenantId var1, CustomerId var2, String var3, PageLink var4);

    public ListenableFuture<List<Edge>> findEdgesByTenantIdCustomerIdAndIdsAsync(TenantId var1, CustomerId var2, List<EdgeId> var3);

    public void unassignCustomerEdges(TenantId var1, CustomerId var2);

    public ListenableFuture<List<Edge>> findEdgesByQuery(TenantId var1, EdgeSearchQuery var2);

    public ListenableFuture<List<EntitySubtype>> findEdgeTypesByTenantId(TenantId var1);

    public void assignDefaultRuleChainsToEdge(TenantId var1, EdgeId var2);

    public PageData<Edge> findEdgesByTenantIdAndEntityId(TenantId var1, EntityId var2, PageLink var3);

    public List<EdgeId> findAllRelatedEdgeIds(TenantId var1, EntityId var2);

    public PageData<EdgeId> findRelatedEdgeIdsByEntityId(TenantId var1, EntityId var2, PageLink var3);

    public String findMissingToRelatedRuleChains(TenantId var1, EdgeId var2, String var3);
}

