/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.alarm.AlarmQueryV2;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.alarm.AlarmUpdateRequest;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.query.AlarmCountQuery;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.common.data.query.AlarmDataQuery;
import org.thingsboard.server.dao.alarm.AlarmOperationResult;
import org.thingsboard.server.dao.entity.EntityDaoService;

public interface AlarmService
extends EntityDaoService {
    public AlarmApiCallResult createAlarm(AlarmCreateOrUpdateActiveRequest var1);

    public AlarmApiCallResult createAlarm(AlarmCreateOrUpdateActiveRequest var1, boolean var2);

    public AlarmApiCallResult updateAlarm(AlarmUpdateRequest var1);

    public AlarmApiCallResult acknowledgeAlarm(TenantId var1, AlarmId var2, long var3);

    public AlarmApiCallResult clearAlarm(TenantId var1, AlarmId var2, long var3, JsonNode var5);

    public AlarmApiCallResult assignAlarm(TenantId var1, AlarmId var2, UserId var3, long var4);

    public AlarmApiCallResult unassignAlarm(TenantId var1, AlarmId var2, long var3);

    public AlarmApiCallResult delAlarm(TenantId var1, AlarmId var2);

    @Deprecated(since="3.5.0", forRemoval=true)
    public AlarmOperationResult createOrUpdateAlarm(Alarm var1);

    @Deprecated(since="3.5.0", forRemoval=true)
    public AlarmOperationResult createOrUpdateAlarm(Alarm var1, boolean var2);

    @Deprecated(since="3.5.0", forRemoval=true)
    public ListenableFuture<AlarmOperationResult> ackAlarm(TenantId var1, AlarmId var2, long var3);

    @Deprecated(since="3.5.0", forRemoval=true)
    public ListenableFuture<AlarmOperationResult> clearAlarm(TenantId var1, AlarmId var2, JsonNode var3, long var4);

    @Deprecated(since="3.5.0", forRemoval=true)
    public AlarmOperationResult deleteAlarm(TenantId var1, AlarmId var2);

    @Deprecated(since="3.5.0", forRemoval=true)
    public ListenableFuture<Alarm> findLatestByOriginatorAndType(TenantId var1, EntityId var2, String var3);

    public Alarm findAlarmById(TenantId var1, AlarmId var2);

    public ListenableFuture<Alarm> findAlarmByIdAsync(TenantId var1, AlarmId var2);

    public AlarmInfo findAlarmInfoById(TenantId var1, AlarmId var2);

    public ListenableFuture<PageData<AlarmInfo>> findAlarms(TenantId var1, AlarmQuery var2);

    public ListenableFuture<PageData<AlarmInfo>> findCustomerAlarms(TenantId var1, CustomerId var2, AlarmQuery var3);

    public ListenableFuture<PageData<AlarmInfo>> findAlarmsV2(TenantId var1, AlarmQueryV2 var2);

    public ListenableFuture<PageData<AlarmInfo>> findCustomerAlarmsV2(TenantId var1, CustomerId var2, AlarmQueryV2 var3);

    public AlarmSeverity findHighestAlarmSeverity(TenantId var1, EntityId var2, AlarmSearchStatus var3, AlarmStatus var4, String var5);

    public Alarm findLatestActiveByOriginatorAndType(TenantId var1, EntityId var2, String var3);

    public PageData<AlarmData> findAlarmDataByQueryForEntities(TenantId var1, AlarmDataQuery var2, Collection<EntityId> var3);

    public void deleteEntityAlarmRelations(TenantId var1, EntityId var2);

    public long countAlarmsByQuery(TenantId var1, CustomerId var2, AlarmCountQuery var3);
}

