/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.alarm;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.EntityId;

@Deprecated
public class AlarmOperationResult {
    private final Alarm alarm;
    private final boolean successful;
    private final boolean created;
    private final AlarmSeverity oldSeverity;
    private final List<EntityId> propagatedEntitiesList;

    public AlarmOperationResult(Alarm alarm, boolean successful) {
        this(alarm, successful, Collections.emptyList());
    }

    public AlarmOperationResult(Alarm alarm, boolean successful, List<EntityId> propagatedEntitiesList) {
        this(alarm, successful, false, null, propagatedEntitiesList);
    }

    public AlarmOperationResult(Alarm alarm, boolean successful, boolean created, List<EntityId> propagatedEntitiesList) {
        this.alarm = alarm;
        this.successful = successful;
        this.created = created;
        this.propagatedEntitiesList = propagatedEntitiesList;
        this.oldSeverity = null;
    }

    public AlarmOperationResult(AlarmApiCallResult result) {
        this.alarm = result.getAlarm() != null ? new Alarm((Alarm)result.getAlarm()) : null;
        this.successful = result.isSuccessful() && (result.isCreated() || result.isModified());
        this.created = result.isCreated();
        this.oldSeverity = result.getOldSeverity();
        this.propagatedEntitiesList = result.getPropagatedEntitiesList();
    }

    public static AlarmOperationResultBuilder builder() {
        return new AlarmOperationResultBuilder();
    }

    public Alarm getAlarm() {
        return this.alarm;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean isCreated() {
        return this.created;
    }

    public AlarmSeverity getOldSeverity() {
        return this.oldSeverity;
    }

    public List<EntityId> getPropagatedEntitiesList() {
        return this.propagatedEntitiesList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmOperationResult)) {
            return false;
        }
        AlarmOperationResult other = (AlarmOperationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        if (this.isCreated() != other.isCreated()) {
            return false;
        }
        Alarm this$alarm = this.getAlarm();
        Alarm other$alarm = other.getAlarm();
        if (this$alarm == null ? other$alarm != null : !this$alarm.equals(other$alarm)) {
            return false;
        }
        AlarmSeverity this$oldSeverity = this.getOldSeverity();
        AlarmSeverity other$oldSeverity = other.getOldSeverity();
        if (this$oldSeverity == null ? other$oldSeverity != null : !this$oldSeverity.equals(other$oldSeverity)) {
            return false;
        }
        List<EntityId> this$propagatedEntitiesList = this.getPropagatedEntitiesList();
        List<EntityId> other$propagatedEntitiesList = other.getPropagatedEntitiesList();
        return !(this$propagatedEntitiesList == null ? other$propagatedEntitiesList != null : !((Object)this$propagatedEntitiesList).equals(other$propagatedEntitiesList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmOperationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        result = result * 59 + (this.isCreated() ? 79 : 97);
        Alarm $alarm = this.getAlarm();
        result = result * 59 + ($alarm == null ? 43 : $alarm.hashCode());
        AlarmSeverity $oldSeverity = this.getOldSeverity();
        result = result * 59 + ($oldSeverity == null ? 43 : $oldSeverity.hashCode());
        List<EntityId> $propagatedEntitiesList = this.getPropagatedEntitiesList();
        result = result * 59 + ($propagatedEntitiesList == null ? 43 : ((Object)$propagatedEntitiesList).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmOperationResult(alarm=" + this.getAlarm() + ", successful=" + this.isSuccessful() + ", created=" + this.isCreated() + ", oldSeverity=" + this.getOldSeverity() + ", propagatedEntitiesList=" + this.getPropagatedEntitiesList() + ")";
    }

    @ConstructorProperties(value={"alarm", "successful", "created", "oldSeverity", "propagatedEntitiesList"})
    public AlarmOperationResult(Alarm alarm, boolean successful, boolean created, AlarmSeverity oldSeverity, List<EntityId> propagatedEntitiesList) {
        this.alarm = alarm;
        this.successful = successful;
        this.created = created;
        this.oldSeverity = oldSeverity;
        this.propagatedEntitiesList = propagatedEntitiesList;
    }

    public static class AlarmOperationResultBuilder {
        private Alarm alarm;
        private boolean successful;
        private boolean created;
        private AlarmSeverity oldSeverity;
        private List<EntityId> propagatedEntitiesList;

        AlarmOperationResultBuilder() {
        }

        public AlarmOperationResultBuilder alarm(Alarm alarm) {
            this.alarm = alarm;
            return this;
        }

        public AlarmOperationResultBuilder successful(boolean successful) {
            this.successful = successful;
            return this;
        }

        public AlarmOperationResultBuilder created(boolean created) {
            this.created = created;
            return this;
        }

        public AlarmOperationResultBuilder oldSeverity(AlarmSeverity oldSeverity) {
            this.oldSeverity = oldSeverity;
            return this;
        }

        public AlarmOperationResultBuilder propagatedEntitiesList(List<EntityId> propagatedEntitiesList) {
            this.propagatedEntitiesList = propagatedEntitiesList;
            return this;
        }

        public AlarmOperationResult build() {
            return new AlarmOperationResult(this.alarm, this.successful, this.created, this.oldSeverity, this.propagatedEntitiesList);
        }

        public String toString() {
            return "AlarmOperationResult.AlarmOperationResultBuilder(alarm=" + this.alarm + ", successful=" + this.successful + ", created=" + this.created + ", oldSeverity=" + this.oldSeverity + ", propagatedEntitiesList=" + this.propagatedEntitiesList + ")";
        }
    }
}

