/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.user;

import com.google.common.util.concurrent.ListenableFuture;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserCredentialsId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.security.UserCredentials;

public interface UserService {
    public User findUserById(TenantId var1, UserId var2);

    public ListenableFuture<User> findUserByIdAsync(TenantId var1, UserId var2);

    public User findUserByEmail(TenantId var1, String var2);

    public User saveUser(User var1);

    public UserCredentials findUserCredentialsByUserId(TenantId var1, UserId var2);

    public UserCredentials findUserCredentialsByActivateToken(TenantId var1, String var2);

    public UserCredentials findUserCredentialsByResetToken(TenantId var1, String var2);

    public UserCredentials saveUserCredentials(TenantId var1, UserCredentials var2);

    public UserCredentials activateUserCredentials(TenantId var1, String var2, String var3);

    public UserCredentials requestPasswordReset(TenantId var1, String var2);

    public UserCredentials requestExpiredPasswordReset(TenantId var1, UserCredentialsId var2);

    public UserCredentials replaceUserCredentials(TenantId var1, UserCredentials var2);

    public void deleteUser(TenantId var1, UserId var2);

    public PageData<User> findUsersByTenantId(TenantId var1, PageLink var2);

    public PageData<User> findTenantAdmins(TenantId var1, PageLink var2);

    public void deleteTenantAdmins(TenantId var1);

    public PageData<User> findCustomerUsers(TenantId var1, CustomerId var2, PageLink var3);

    public void deleteCustomerUsers(TenantId var1, CustomerId var2);

    public void setUserCredentialsEnabled(TenantId var1, UserId var2, boolean var3);

    public void resetFailedLoginAttempts(TenantId var1, UserId var2);

    public int increaseFailedLoginAttempts(TenantId var1, UserId var2);

    public void setLastLoginTs(TenantId var1, UserId var2);
}

