/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.dashboard;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;

public interface DashboardService {
    public Dashboard findDashboardById(TenantId var1, DashboardId var2);

    public ListenableFuture<Dashboard> findDashboardByIdAsync(TenantId var1, DashboardId var2);

    public DashboardInfo findDashboardInfoById(TenantId var1, DashboardId var2);

    public ListenableFuture<DashboardInfo> findDashboardInfoByIdAsync(TenantId var1, DashboardId var2);

    public Dashboard saveDashboard(Dashboard var1);

    public Dashboard assignDashboardToCustomer(TenantId var1, DashboardId var2, CustomerId var3);

    public Dashboard unassignDashboardFromCustomer(TenantId var1, DashboardId var2, CustomerId var3);

    public void deleteDashboard(TenantId var1, DashboardId var2);

    public PageData<DashboardInfo> findDashboardsByTenantId(TenantId var1, PageLink var2);

    public PageData<DashboardInfo> findMobileDashboardsByTenantId(TenantId var1, PageLink var2);

    public void deleteDashboardsByTenantId(TenantId var1);

    public PageData<DashboardInfo> findDashboardsByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<DashboardInfo> findMobileDashboardsByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public void unassignCustomerDashboards(TenantId var1, CustomerId var2);

    public void updateCustomerDashboards(TenantId var1, CustomerId var2);

    public Dashboard assignDashboardToEdge(TenantId var1, DashboardId var2, EdgeId var3);

    public Dashboard unassignDashboardFromEdge(TenantId var1, DashboardId var2, EdgeId var3);

    public PageData<DashboardInfo> findDashboardsByTenantIdAndEdgeId(TenantId var1, EdgeId var2, PageLink var3);

    public DashboardInfo findFirstDashboardInfoByTenantIdAndName(TenantId var1, String var2);

    public List<Dashboard> findTenantDashboardsByTitle(TenantId var1, String var2);
}

