/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.alarm;

import java.util.Collections;
import java.util.List;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.id.EntityId;

public class AlarmOperationResult {
    private final Alarm alarm;
    private final boolean successful;
    private final boolean created;
    private final List<EntityId> propagatedEntitiesList;

    public AlarmOperationResult(Alarm alarm, boolean successful) {
        this(alarm, successful, Collections.emptyList());
    }

    public AlarmOperationResult(Alarm alarm, boolean successful, List<EntityId> propagatedEntitiesList) {
        this(alarm, successful, false, propagatedEntitiesList);
    }

    public AlarmOperationResult(Alarm alarm, boolean successful, boolean created, List<EntityId> propagatedEntitiesList) {
        this.alarm = alarm;
        this.successful = successful;
        this.created = created;
        this.propagatedEntitiesList = propagatedEntitiesList;
    }

    public Alarm getAlarm() {
        return this.alarm;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean isCreated() {
        return this.created;
    }

    public List<EntityId> getPropagatedEntitiesList() {
        return this.propagatedEntitiesList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmOperationResult)) {
            return false;
        }
        AlarmOperationResult other = (AlarmOperationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        if (this.isCreated() != other.isCreated()) {
            return false;
        }
        Alarm this$alarm = this.getAlarm();
        Alarm other$alarm = other.getAlarm();
        if (this$alarm == null ? other$alarm != null : !this$alarm.equals(other$alarm)) {
            return false;
        }
        List<EntityId> this$propagatedEntitiesList = this.getPropagatedEntitiesList();
        List<EntityId> other$propagatedEntitiesList = other.getPropagatedEntitiesList();
        return !(this$propagatedEntitiesList == null ? other$propagatedEntitiesList != null : !((Object)this$propagatedEntitiesList).equals(other$propagatedEntitiesList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmOperationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        result = result * 59 + (this.isCreated() ? 79 : 97);
        Alarm $alarm = this.getAlarm();
        result = result * 59 + ($alarm == null ? 43 : $alarm.hashCode());
        List<EntityId> $propagatedEntitiesList = this.getPropagatedEntitiesList();
        result = result * 59 + ($propagatedEntitiesList == null ? 43 : ((Object)$propagatedEntitiesList).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmOperationResult(alarm=" + this.getAlarm() + ", successful=" + this.isSuccessful() + ", created=" + this.isCreated() + ", propagatedEntitiesList=" + this.getPropagatedEntitiesList() + ")";
    }
}

