/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.scheduler;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;
import org.thingsboard.server.common.data.scheduler.SchedulerEventWithCustomerInfo;

public interface SchedulerEventService {
    public SchedulerEvent findSchedulerEventById(TenantId var1, SchedulerEventId var2);

    public SchedulerEventInfo findSchedulerEventInfoById(TenantId var1, SchedulerEventId var2);

    public SchedulerEventWithCustomerInfo findSchedulerEventWithCustomerInfoById(TenantId var1, SchedulerEventId var2);

    public ListenableFuture<SchedulerEventInfo> findSchedulerEventInfoByIdAsync(TenantId var1, SchedulerEventId var2);

    public ListenableFuture<List<SchedulerEventInfo>> findSchedulerEventInfoByIdsAsync(TenantId var1, List<SchedulerEventId> var2);

    public List<SchedulerEventInfo> findSchedulerEventsByTenantId(TenantId var1);

    public List<SchedulerEventWithCustomerInfo> findSchedulerEventsWithCustomerInfoByTenantId(TenantId var1);

    public List<SchedulerEventWithCustomerInfo> findSchedulerEventsByTenantIdAndType(TenantId var1, String var2);

    public List<SchedulerEventWithCustomerInfo> findSchedulerEventsByTenantIdAndCustomerId(TenantId var1, CustomerId var2);

    public List<SchedulerEventWithCustomerInfo> findSchedulerEventsByTenantIdAndCustomerIdAndType(TenantId var1, CustomerId var2, String var3);

    public SchedulerEvent saveSchedulerEvent(SchedulerEvent var1);

    public void deleteSchedulerEvent(TenantId var1, SchedulerEventId var2);

    public void deleteSchedulerEventsByTenantId(TenantId var1);

    public void deleteSchedulerEventsByTenantIdAndCustomerId(TenantId var1, CustomerId var2);

    public SchedulerEventInfo assignSchedulerEventToEdge(TenantId var1, SchedulerEventId var2, EdgeId var3);

    public SchedulerEventInfo unassignSchedulerEventFromEdge(TenantId var1, SchedulerEventId var2, EdgeId var3);

    public PageData<SchedulerEvent> findSchedulerEventsByTenantIdAndEdgeId(TenantId var1, EdgeId var2, PageLink var3);

    public PageData<SchedulerEventInfo> findSchedulerEventInfosByTenantIdAndEdgeId(TenantId var1, EdgeId var2, PageLink var3);
}

