/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.role;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.role.RoleType;

public interface RoleService {
    public Role saveRole(TenantId var1, Role var2);

    public Role findRoleById(TenantId var1, RoleId var2);

    public ListenableFuture<List<Role>> findRolesByIdsAsync(TenantId var1, List<RoleId> var2);

    public Optional<Role> findRoleByTenantIdAndName(TenantId var1, String var2);

    public Optional<Role> findRoleByByTenantIdAndCustomerIdAndName(TenantId var1, CustomerId var2, String var3);

    public PageData<Role> findRolesByTenantId(TenantId var1, PageLink var2);

    public PageData<Role> findRolesByTenantIdAndType(TenantId var1, PageLink var2, RoleType var3);

    public ListenableFuture<Role> findRoleByIdAsync(TenantId var1, RoleId var2);

    public void deleteRole(TenantId var1, RoleId var2);

    public void deleteRolesByTenantId(TenantId var1);

    public void deleteRolesByTenantIdAndCustomerId(TenantId var1, CustomerId var2);

    public Role findOrCreateRole(TenantId var1, CustomerId var2, RoleType var3, String var4, Object var5, String var6);

    public Role findOrCreateTenantUserRole();

    public Role findOrCreateTenantAdminRole();

    public Role findOrCreateCustomerUserRole(TenantId var1, CustomerId var2);

    public Role findOrCreateCustomerAdminRole(TenantId var1, CustomerId var2);

    public Role findOrCreatePublicUsersEntityGroupRole(TenantId var1, CustomerId var2);

    public Role findOrCreatePublicUserRole(TenantId var1, CustomerId var2);

    public Role findOrCreateReadOnlyEntityGroupRole(TenantId var1, CustomerId var2);

    public Role findOrCreateWriteEntityGroupRole(TenantId var1, CustomerId var2);

    public PageData<Role> findRolesByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<Role> findRolesByTenantIdAndCustomerIdAndType(TenantId var1, CustomerId var2, RoleType var3, PageLink var4);
}

