/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.nosql;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.beans.ConstructorProperties;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.cassandra.guava.GuavaSession;
import org.thingsboard.server.dao.nosql.TbResultSet;
import org.thingsboard.server.dao.nosql.TbResultSetFuture;
import org.thingsboard.server.dao.util.AsyncTask;

public class CassandraStatementTask
implements AsyncTask {
    private final TenantId tenantId;
    private final GuavaSession session;
    private final Statement statement;

    public ListenableFuture<TbResultSet> executeAsync(Function<Statement, TbResultSetFuture> executeAsyncFunction) {
        return Futures.transform(this.session.executeAsync(this.statement), result -> new TbResultSet(this.statement, (AsyncResultSet)result, executeAsyncFunction), (Executor)MoreExecutors.directExecutor());
    }

    @ConstructorProperties(value={"tenantId", "session", "statement"})
    public CassandraStatementTask(TenantId tenantId, GuavaSession session, Statement statement) {
        this.tenantId = tenantId;
        this.session = session;
        this.statement = statement;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public GuavaSession getSession() {
        return this.session;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraStatementTask)) {
            return false;
        }
        CassandraStatementTask other = (CassandraStatementTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        GuavaSession this$session = this.getSession();
        GuavaSession other$session = other.getSession();
        if (this$session == null ? other$session != null : !this$session.equals(other$session)) {
            return false;
        }
        Statement this$statement = this.getStatement();
        Statement other$statement = other.getStatement();
        return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CassandraStatementTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        GuavaSession $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        Statement $statement = this.getStatement();
        result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
        return result;
    }

    public String toString() {
        return "CassandraStatementTask(tenantId=" + this.getTenantId() + ", session=" + this.getSession() + ", statement=" + this.getStatement() + ")";
    }
}

