/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.customer;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.role.Role;

public interface CustomerService {
    public Customer findCustomerById(TenantId var1, CustomerId var2);

    public Optional<Customer> findCustomerByTenantIdAndTitle(TenantId var1, String var2);

    public ListenableFuture<Customer> findCustomerByIdAsync(TenantId var1, CustomerId var2);

    public ListenableFuture<List<Customer>> findCustomersByTenantIdAndIdsAsync(TenantId var1, List<CustomerId> var2);

    public Customer saveCustomer(Customer var1);

    public void deleteCustomer(TenantId var1, CustomerId var2);

    public Customer findOrCreatePublicCustomer(TenantId var1, EntityId var2);

    public EntityGroup findOrCreatePublicUserGroup(TenantId var1, EntityId var2);

    public Role findOrCreatePublicUserEntityGroupRole(TenantId var1, EntityId var2);

    public PageData<Customer> findCustomersByTenantId(TenantId var1, PageLink var2);

    public void deleteCustomersByTenantId(TenantId var1);

    public PageData<Customer> findCustomersByEntityGroupId(EntityGroupId var1, PageLink var2);

    public PageData<Customer> findCustomersByEntityGroupIds(List<EntityGroupId> var1, List<CustomerId> var2, PageLink var3);
}

