/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmFilter;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.common.data.query.AlarmDataQuery;
import org.thingsboard.server.dao.alarm.AlarmOperationResult;

public interface AlarmService {
    public AlarmOperationResult createOrUpdateAlarm(Alarm var1);

    public AlarmOperationResult createOrUpdateAlarm(Alarm var1, boolean var2);

    public AlarmOperationResult deleteAlarm(TenantId var1, AlarmId var2);

    public ListenableFuture<AlarmOperationResult> ackAlarm(TenantId var1, AlarmId var2, long var3);

    public ListenableFuture<AlarmOperationResult> clearAlarm(TenantId var1, AlarmId var2, JsonNode var3, long var4);

    public ListenableFuture<Alarm> findAlarmByIdAsync(TenantId var1, AlarmId var2);

    public ListenableFuture<AlarmInfo> findAlarmInfoByIdAsync(TenantId var1, AlarmId var2);

    public ListenableFuture<PageData<AlarmInfo>> findAlarms(TenantId var1, AlarmQuery var2);

    public ListenableFuture<PageData<AlarmInfo>> findCustomerAlarms(TenantId var1, CustomerId var2, AlarmQuery var3);

    public List<Long> findAlarmCounts(TenantId var1, AlarmQuery var2, List<AlarmFilter> var3);

    public AlarmSeverity findHighestAlarmSeverity(TenantId var1, EntityId var2, AlarmSearchStatus var3, AlarmStatus var4);

    public ListenableFuture<Alarm> findLatestByOriginatorAndType(TenantId var1, EntityId var2, String var3);

    public PageData<AlarmData> findAlarmDataByQueryForEntities(TenantId var1, MergedUserPermissions var2, AlarmDataQuery var3, Collection<EntityId> var4);

    public Set<EntityId> getPropagationEntityIds(Alarm var1);

    public Set<EntityId> getPropagationEntityIds(Alarm var1, List<EntityType> var2);

    public void deleteEntityAlarmRelations(TenantId var1, EntityId var2);
}

