/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.device;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceInfo;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.device.DeviceSearchQuery;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.dao.device.provision.ProvisionRequest;

public interface DeviceService {
    public DeviceInfo findDeviceInfoById(TenantId var1, DeviceId var2);

    public Device findDeviceById(TenantId var1, DeviceId var2);

    public ListenableFuture<Device> findDeviceByIdAsync(TenantId var1, DeviceId var2);

    public Device findDeviceByTenantIdAndName(TenantId var1, String var2);

    public Device saveDevice(Device var1, boolean var2);

    public Device saveDevice(Device var1);

    public Device saveDeviceWithAccessToken(Device var1, String var2);

    public Device saveDeviceWithCredentials(Device var1, DeviceCredentials var2);

    public Device saveDevice(ProvisionRequest var1, DeviceProfile var2);

    public Device assignDeviceToCustomer(TenantId var1, DeviceId var2, CustomerId var3);

    public Device unassignDeviceFromCustomer(TenantId var1, DeviceId var2);

    public void deleteDevice(TenantId var1, DeviceId var2);

    public PageData<Device> findDevicesByTenantId(TenantId var1, PageLink var2);

    public PageData<DeviceInfo> findDeviceInfosByTenantId(TenantId var1, PageLink var2);

    public PageData<Device> findDevicesByTenantIdAndType(TenantId var1, String var2, PageLink var3);

    public PageData<Device> findDevicesByTenantIdAndTypeAndEmptyOtaPackage(TenantId var1, DeviceProfileId var2, OtaPackageType var3, PageLink var4);

    public Long countDevicesByTenantIdAndDeviceProfileIdAndEmptyOtaPackage(TenantId var1, DeviceProfileId var2, OtaPackageType var3);

    public PageData<DeviceInfo> findDeviceInfosByTenantIdAndType(TenantId var1, String var2, PageLink var3);

    public PageData<DeviceInfo> findDeviceInfosByTenantIdAndDeviceProfileId(TenantId var1, DeviceProfileId var2, PageLink var3);

    public ListenableFuture<List<Device>> findDevicesByTenantIdAndIdsAsync(TenantId var1, List<DeviceId> var2);

    public void deleteDevicesByTenantId(TenantId var1);

    public PageData<Device> findDevicesByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<DeviceInfo> findDeviceInfosByTenantIdAndCustomerId(TenantId var1, CustomerId var2, PageLink var3);

    public PageData<Device> findDevicesByTenantIdAndCustomerIdAndType(TenantId var1, CustomerId var2, String var3, PageLink var4);

    public PageData<DeviceInfo> findDeviceInfosByTenantIdAndCustomerIdAndType(TenantId var1, CustomerId var2, String var3, PageLink var4);

    public PageData<DeviceInfo> findDeviceInfosByTenantIdAndCustomerIdAndDeviceProfileId(TenantId var1, CustomerId var2, DeviceProfileId var3, PageLink var4);

    public ListenableFuture<List<Device>> findDevicesByTenantIdCustomerIdAndIdsAsync(TenantId var1, CustomerId var2, List<DeviceId> var3);

    public void unassignCustomerDevices(TenantId var1, CustomerId var2);

    public ListenableFuture<List<Device>> findDevicesByQuery(TenantId var1, DeviceSearchQuery var2);

    public ListenableFuture<List<EntitySubtype>> findDeviceTypesByTenantId(TenantId var1);

    public Device assignDeviceToTenant(TenantId var1, Device var2);

    public PageData<UUID> findDevicesIdsByDeviceProfileTransportType(DeviceTransportType var1, PageLink var2);

    public Device assignDeviceToEdge(TenantId var1, DeviceId var2, EdgeId var3);

    public Device unassignDeviceFromEdge(TenantId var1, DeviceId var2, EdgeId var3);

    public PageData<Device> findDevicesByTenantIdAndEdgeId(TenantId var1, EdgeId var2, PageLink var3);

    public PageData<Device> findDevicesByTenantIdAndEdgeIdAndType(TenantId var1, EdgeId var2, String var3, PageLink var4);

    public long countByTenantId(TenantId var1);
}

