/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.rule;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainData;
import org.thingsboard.server.common.data.rule.RuleChainImportResult;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.rule.RuleNode;

public interface RuleChainService {
    public RuleChain saveRuleChain(RuleChain var1);

    public boolean setRootRuleChain(TenantId var1, RuleChainId var2);

    public boolean saveRuleChainMetaData(TenantId var1, RuleChainMetaData var2);

    public RuleChainMetaData loadRuleChainMetaData(TenantId var1, RuleChainId var2);

    public RuleChain findRuleChainById(TenantId var1, RuleChainId var2);

    public RuleNode findRuleNodeById(TenantId var1, RuleNodeId var2);

    public ListenableFuture<RuleChain> findRuleChainByIdAsync(TenantId var1, RuleChainId var2);

    public ListenableFuture<RuleNode> findRuleNodeByIdAsync(TenantId var1, RuleNodeId var2);

    public RuleChain getRootTenantRuleChain(TenantId var1);

    public List<RuleNode> getRuleChainNodes(TenantId var1, RuleChainId var2);

    public List<RuleNode> getReferencingRuleChainNodes(TenantId var1, RuleChainId var2);

    public List<EntityRelation> getRuleNodeRelations(TenantId var1, RuleNodeId var2);

    public PageData<RuleChain> findTenantRuleChainsByType(TenantId var1, RuleChainType var2, PageLink var3);

    public void deleteRuleChainById(TenantId var1, RuleChainId var2);

    public void deleteRuleChainsByTenantId(TenantId var1);

    public RuleChainData exportTenantRuleChains(TenantId var1, PageLink var2) throws ThingsboardException;

    public List<RuleChainImportResult> importTenantRuleChains(TenantId var1, RuleChainData var2, RuleChainType var3, boolean var4);

    public RuleChain assignRuleChainToEdge(TenantId var1, RuleChainId var2, EdgeId var3);

    public RuleChain unassignRuleChainFromEdge(TenantId var1, RuleChainId var2, EdgeId var3, boolean var4);

    public PageData<RuleChain> findRuleChainsByTenantIdAndEdgeId(TenantId var1, EdgeId var2, PageLink var3);

    public RuleChain getEdgeTemplateRootRuleChain(TenantId var1);

    public boolean setEdgeTemplateRootRuleChain(TenantId var1, RuleChainId var2);

    public boolean setAutoAssignToEdgeRuleChain(TenantId var1, RuleChainId var2);

    public boolean unsetAutoAssignToEdgeRuleChain(TenantId var1, RuleChainId var2);

    public PageData<RuleChain> findAutoAssignToEdgeRuleChainsByTenantId(TenantId var1, PageLink var2);
}

