/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.nosql;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.thingsboard.server.dao.nosql.TbResultSetFuture;

public class TbResultSet
implements AsyncResultSet {
    private final Statement originalStatement;
    private final AsyncResultSet delegate;
    private final Function<Statement, TbResultSetFuture> executeAsyncFunction;

    public TbResultSet(Statement originalStatement, AsyncResultSet delegate, Function<Statement, TbResultSetFuture> executeAsyncFunction) {
        this.originalStatement = originalStatement;
        this.delegate = delegate;
        this.executeAsyncFunction = executeAsyncFunction;
    }

    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.delegate.getColumnDefinitions();
    }

    @NonNull
    public ExecutionInfo getExecutionInfo() {
        return this.delegate.getExecutionInfo();
    }

    public int remaining() {
        return this.delegate.remaining();
    }

    @NonNull
    public Iterable<Row> currentPage() {
        return this.delegate.currentPage();
    }

    public boolean hasMorePages() {
        return this.delegate.hasMorePages();
    }

    @NonNull
    public CompletionStage<AsyncResultSet> fetchNextPage() throws IllegalStateException {
        return this.delegate.fetchNextPage();
    }

    public boolean wasApplied() {
        return this.delegate.wasApplied();
    }

    public ListenableFuture<List<Row>> allRows(Executor executor) {
        ArrayList<Row> allRows = new ArrayList<Row>();
        SettableFuture resultFuture = SettableFuture.create();
        this.processRows(this.originalStatement, this.delegate, allRows, (SettableFuture<List<Row>>)resultFuture, executor);
        return resultFuture;
    }

    private void processRows(Statement statement, AsyncResultSet resultSet, final List<Row> allRows, final SettableFuture<List<Row>> resultFuture, final Executor executor) {
        allRows.addAll(this.loadRows(resultSet));
        if (resultSet.hasMorePages()) {
            ByteBuffer nextPagingState = resultSet.getExecutionInfo().getPagingState();
            final Statement nextStatement = statement.setPagingState(nextPagingState);
            TbResultSetFuture resultSetFuture = this.executeAsyncFunction.apply(nextStatement);
            Futures.addCallback((ListenableFuture)resultSetFuture, (FutureCallback)new FutureCallback<TbResultSet>(){

                public void onSuccess(@Nullable TbResultSet result) {
                    TbResultSet.this.processRows(nextStatement, result, allRows, (SettableFuture<List<Row>>)resultFuture, executor);
                }

                public void onFailure(Throwable t) {
                    resultFuture.setException(t);
                }
            }, (Executor)(executor != null ? executor : MoreExecutors.directExecutor()));
        } else {
            resultFuture.set(allRows);
        }
    }

    List<Row> loadRows(AsyncResultSet resultSet) {
        return Lists.newArrayList((Iterable)resultSet.currentPage());
    }
}

