/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.group;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ShortEntityView;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;

public interface EntityGroupService {
    public EntityGroup findEntityGroupById(TenantId var1, EntityGroupId var2);

    public ListenableFuture<EntityGroup> findEntityGroupByIdAsync(TenantId var1, EntityGroupId var2);

    public ListenableFuture<List<EntityGroup>> findEntityGroupByIdsAsync(TenantId var1, List<EntityGroupId> var2);

    public ListenableFuture<Boolean> checkEntityGroup(TenantId var1, EntityId var2, EntityGroup var3);

    public ListenableFuture<Boolean> checkEntityGroup(TenantId var1, EntityId var2, EntityGroupId var3, EntityType var4);

    public EntityGroup saveEntityGroup(TenantId var1, EntityId var2, EntityGroup var3);

    public EntityGroup createEntityGroupAll(TenantId var1, EntityId var2, EntityType var3);

    public EntityGroup findOrCreateUserGroup(TenantId var1, EntityId var2, String var3, String var4);

    public EntityGroup findOrCreateEntityGroup(TenantId var1, EntityId var2, EntityType var3, String var4, String var5, CustomerId var6);

    public Optional<EntityGroup> findOwnerEntityGroup(TenantId var1, EntityId var2, EntityType var3, String var4);

    public EntityGroup findOrCreateTenantUsersGroup(TenantId var1);

    public EntityGroup findOrCreateTenantAdminsGroup(TenantId var1);

    public EntityGroup findOrCreateCustomerUsersGroup(TenantId var1, CustomerId var2, CustomerId var3);

    public EntityGroup findOrCreateCustomerAdminsGroup(TenantId var1, CustomerId var2, CustomerId var3);

    public EntityGroup findOrCreatePublicUsersGroup(TenantId var1, CustomerId var2);

    public EntityGroup findOrCreateReadOnlyEntityGroupForCustomer(TenantId var1, CustomerId var2, EntityType var3);

    public ListenableFuture<Optional<EntityGroup>> findPublicUserGroup(TenantId var1, CustomerId var2);

    public void deleteEntityGroup(TenantId var1, EntityGroupId var2);

    public ListenableFuture<List<EntityGroup>> findAllEntityGroups(TenantId var1, EntityId var2);

    public void deleteAllEntityGroups(TenantId var1, EntityId var2);

    public ListenableFuture<List<EntityGroup>> findEntityGroupsByType(TenantId var1, EntityId var2, EntityType var3);

    public ListenableFuture<PageData<EntityGroup>> findEntityGroupsByTypeAndPageLink(TenantId var1, EntityId var2, EntityType var3, PageLink var4);

    public ListenableFuture<Optional<EntityGroup>> findEntityGroupByTypeAndName(TenantId var1, EntityId var2, EntityType var3, String var4);

    public void addEntityToEntityGroup(TenantId var1, EntityGroupId var2, EntityId var3);

    public void addEntityToEntityGroupAll(TenantId var1, EntityId var2, EntityId var3);

    public void addEntitiesToEntityGroup(TenantId var1, EntityGroupId var2, List<EntityId> var3);

    public void removeEntityFromEntityGroup(TenantId var1, EntityGroupId var2, EntityId var3);

    public void removeEntitiesFromEntityGroup(TenantId var1, EntityGroupId var2, List<EntityId> var3);

    public ShortEntityView findGroupEntity(TenantId var1, CustomerId var2, MergedUserPermissions var3, EntityGroupId var4, EntityId var5);

    public PageData<ShortEntityView> findGroupEntities(TenantId var1, CustomerId var2, MergedUserPermissions var3, EntityGroupId var4, PageLink var5);

    public ListenableFuture<List<EntityId>> findAllEntityIds(TenantId var1, EntityGroupId var2, PageLink var3);

    public ListenableFuture<List<EntityGroupId>> findEntityGroupsForEntity(TenantId var1, EntityId var2);

    public boolean isEntityInGroup(EntityId var1, EntityGroupId var2);

    public EntityGroup assignEntityGroupToEdge(TenantId var1, EntityGroupId var2, EdgeId var3, EntityType var4);

    public EntityGroup unassignEntityGroupFromEdge(TenantId var1, EntityGroupId var2, EdgeId var3, EntityType var4);

    public PageData<EntityGroup> findEdgeEntityGroupsByType(TenantId var1, EdgeId var2, EntityType var3, PageLink var4);

    public ListenableFuture<Boolean> checkEdgeEntityGroupById(TenantId var1, EdgeId var2, EntityGroupId var3, EntityType var4);

    public ListenableFuture<EntityGroup> findOrCreateEdgeAllGroup(TenantId var1, Edge var2, String var3, EntityType var4);
}

