/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.cassandra;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.thingsboard.server.dao.cassandra.CassandraDriverOptions;
import org.thingsboard.server.dao.cassandra.guava.GuavaSession;
import org.thingsboard.server.dao.cassandra.guava.GuavaSessionBuilder;
import org.thingsboard.server.dao.cassandra.guava.GuavaSessionUtils;

public abstract class AbstractCassandraCluster {
    private static final Logger log = LoggerFactory.getLogger(AbstractCassandraCluster.class);
    @Value(value="${cassandra.jmx}")
    private Boolean jmx;
    @Value(value="${cassandra.metrics}")
    private Boolean metrics;
    @Value(value="${cassandra.local_datacenter:datacenter1}")
    private String localDatacenter;
    @Autowired
    private CassandraDriverOptions driverOptions;
    @Autowired
    private Environment environment;
    private GuavaSessionBuilder sessionBuilder;
    private GuavaSession session;
    private JmxReporter reporter;
    private String keyspaceName;

    protected void init(String keyspaceName) {
        this.keyspaceName = keyspaceName;
        this.sessionBuilder = (GuavaSessionBuilder)GuavaSessionUtils.builder().withConfigLoader(this.driverOptions.getLoader());
        if (!this.isInstall()) {
            this.initSession();
        }
    }

    public GuavaSession getSession() {
        if (!this.isInstall()) {
            return this.session;
        }
        if (this.session == null) {
            this.initSession();
        }
        return this.session;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    private boolean isInstall() {
        return this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"install"}));
    }

    private void initSession() {
        if (this.keyspaceName != null) {
            this.sessionBuilder.withKeyspace(this.keyspaceName);
        }
        this.sessionBuilder.withLocalDatacenter(this.localDatacenter);
        this.session = (GuavaSession)this.sessionBuilder.build();
        if (this.metrics.booleanValue() && this.jmx.booleanValue()) {
            MetricRegistry registry = ((Metrics)this.session.getMetrics().orElseThrow(() -> new IllegalStateException("Metrics are disabled"))).getRegistry();
            this.reporter = JmxReporter.forRegistry((MetricRegistry)registry).inDomain("com.datastax.oss.driver").build();
            this.reporter.start();
        }
    }

    @PreDestroy
    public void close() {
        if (this.reporter != null) {
            this.reporter.stop();
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    public ConsistencyLevel getDefaultReadConsistencyLevel() {
        return this.driverOptions.getDefaultReadConsistencyLevel();
    }

    public ConsistencyLevel getDefaultWriteConsistencyLevel() {
        return this.driverOptions.getDefaultWriteConsistencyLevel();
    }
}

