/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.coapserver;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.coapserver.TbCoapDtlsSessionInfo;
import org.thingsboard.server.coapserver.TbCoapDtlsSessionKey;

public class TbCoapDtlsSessionInMemoryStorage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbCoapDtlsSessionInMemoryStorage.class);
    private final ConcurrentMap<TbCoapDtlsSessionKey, TbCoapDtlsSessionInfo> dtlsSessionsMap = new ConcurrentHashMap<TbCoapDtlsSessionKey, TbCoapDtlsSessionInfo>();
    private long dtlsSessionInactivityTimeout;
    private long dtlsSessionReportTimeout;

    public TbCoapDtlsSessionInMemoryStorage(long dtlsSessionInactivityTimeout, long dtlsSessionReportTimeout) {
        this.dtlsSessionInactivityTimeout = dtlsSessionInactivityTimeout;
        this.dtlsSessionReportTimeout = dtlsSessionReportTimeout;
    }

    public void put(TbCoapDtlsSessionKey tbCoapDtlsSessionKey, TbCoapDtlsSessionInfo dtlsSessionInfo) {
        log.trace("DTLS session added to in-memory store: [{}] timestamp: [{}]", (Object)tbCoapDtlsSessionKey, (Object)dtlsSessionInfo.getLastActivityTime());
        this.dtlsSessionsMap.putIfAbsent(tbCoapDtlsSessionKey, dtlsSessionInfo);
    }

    public void evictTimeoutSessions() {
        long expTime = System.currentTimeMillis() - this.dtlsSessionInactivityTimeout;
        this.dtlsSessionsMap.entrySet().removeIf(entry -> {
            if (((TbCoapDtlsSessionInfo)entry.getValue()).getLastActivityTime() < expTime) {
                log.trace("DTLS session was removed from in-memory store: [{}]", entry.getKey());
                return true;
            }
            return false;
        });
    }

    @Generated
    public ConcurrentMap<TbCoapDtlsSessionKey, TbCoapDtlsSessionInfo> getDtlsSessionsMap() {
        return this.dtlsSessionsMap;
    }

    @Generated
    public long getDtlsSessionInactivityTimeout() {
        return this.dtlsSessionInactivityTimeout;
    }

    @Generated
    public long getDtlsSessionReportTimeout() {
        return this.dtlsSessionReportTimeout;
    }

    @Generated
    public void setDtlsSessionInactivityTimeout(long dtlsSessionInactivityTimeout) {
        this.dtlsSessionInactivityTimeout = dtlsSessionInactivityTimeout;
    }

    @Generated
    public void setDtlsSessionReportTimeout(long dtlsSessionReportTimeout) {
        this.dtlsSessionReportTimeout = dtlsSessionReportTimeout;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbCoapDtlsSessionInMemoryStorage)) {
            return false;
        }
        TbCoapDtlsSessionInMemoryStorage other = (TbCoapDtlsSessionInMemoryStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDtlsSessionInactivityTimeout() != other.getDtlsSessionInactivityTimeout()) {
            return false;
        }
        if (this.getDtlsSessionReportTimeout() != other.getDtlsSessionReportTimeout()) {
            return false;
        }
        ConcurrentMap<TbCoapDtlsSessionKey, TbCoapDtlsSessionInfo> this$dtlsSessionsMap = this.getDtlsSessionsMap();
        ConcurrentMap<TbCoapDtlsSessionKey, TbCoapDtlsSessionInfo> other$dtlsSessionsMap = other.getDtlsSessionsMap();
        return !(this$dtlsSessionsMap == null ? other$dtlsSessionsMap != null : !this$dtlsSessionsMap.equals(other$dtlsSessionsMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TbCoapDtlsSessionInMemoryStorage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $dtlsSessionInactivityTimeout = this.getDtlsSessionInactivityTimeout();
        result = result * 59 + (int)($dtlsSessionInactivityTimeout >>> 32 ^ $dtlsSessionInactivityTimeout);
        long $dtlsSessionReportTimeout = this.getDtlsSessionReportTimeout();
        result = result * 59 + (int)($dtlsSessionReportTimeout >>> 32 ^ $dtlsSessionReportTimeout);
        ConcurrentMap<TbCoapDtlsSessionKey, TbCoapDtlsSessionInfo> $dtlsSessionsMap = this.getDtlsSessionsMap();
        result = result * 59 + ($dtlsSessionsMap == null ? 43 : $dtlsSessionsMap.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TbCoapDtlsSessionInMemoryStorage(dtlsSessionsMap=" + String.valueOf(this.getDtlsSessionsMap()) + ", dtlsSessionInactivityTimeout=" + this.getDtlsSessionInactivityTimeout() + ", dtlsSessionReportTimeout=" + this.getDtlsSessionReportTimeout() + ")";
    }
}

