/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.coapserver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.thingsboard.server.coapserver.TbCoapDtlsCertificateVerifier;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.config.ssl.SslCredentials;
import org.thingsboard.server.common.transport.config.ssl.SslCredentialsConfig;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;

@ConditionalOnProperty(prefix="coap.dtls", value={"enabled"}, havingValue="true")
@Component
public class TbCoapDtlsSettings {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbCoapDtlsSettings.class);
    @Value(value="${coap.dtls.bind_address}")
    private String host;
    @Value(value="${coap.dtls.bind_port}")
    private Integer port;
    @Value(value="${coap.dtls.retransmission_timeout:9000}")
    private int dtlsRetransmissionTimeout;
    @Value(value="${coap.dtls.connection_id_length:}")
    private Integer cIdLength;
    @Value(value="${coap.dtls.max_transmission_unit:1024}")
    private Integer maxTransmissionUnit;
    @Value(value="${coap.dtls.max_fragment_length:1024}")
    private Integer maxFragmentLength;
    @Autowired
    @Qualifier(value="coapDtlsCredentials")
    private SslCredentialsConfig coapDtlsCredentialsConfig;
    @Value(value="${coap.dtls.x509.skip_validity_check_for_client_cert:false}")
    private boolean skipValidityCheckForClientCert;
    @Value(value="${coap.dtls.x509.dtls_session_inactivity_timeout:86400000}")
    private long dtlsSessionInactivityTimeout;
    @Value(value="${coap.dtls.x509.dtls_session_report_timeout:1800000}")
    private long dtlsSessionReportTimeout;
    @Autowired(required=false)
    private TransportService transportService;
    @Autowired(required=false)
    private TbServiceInfoProvider serviceInfoProvider;

    @Bean
    @ConfigurationProperties(prefix="coap.dtls.credentials")
    public SslCredentialsConfig coapDtlsCredentials() {
        return new SslCredentialsConfig("COAP DTLS Credentials", false);
    }

    public DtlsConnectorConfig dtlsConnectorConfig(Configuration configuration) throws UnknownHostException {
        MaxFragmentLengthExtension.Length length;
        DtlsConnectorConfig.Builder configBuilder = new DtlsConnectorConfig.Builder(configuration);
        configBuilder.setAddress(this.getInetSocketAddress());
        SslCredentials sslCredentials = this.coapDtlsCredentialsConfig.getCredentials();
        SslContextUtil.Credentials serverCredentials = new SslContextUtil.Credentials(sslCredentials.getPrivateKey(), null, sslCredentials.getCertificateChain());
        configBuilder.set((BasicDefinition)DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE, (Object)CertificateAuthenticationMode.WANTED);
        configBuilder.set(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, this.dtlsRetransmissionTimeout, TimeUnit.MILLISECONDS);
        configBuilder.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.SERVER_ONLY);
        if (this.cIdLength != null) {
            configBuilder.set((BasicDefinition)DtlsConfig.DTLS_CONNECTION_ID_LENGTH, (Object)this.cIdLength);
            if (this.cIdLength > 4) {
                configBuilder.set((BasicDefinition)DtlsConfig.DTLS_CONNECTION_ID_NODE_ID, (Object)0);
            } else {
                configBuilder.set((BasicDefinition)DtlsConfig.DTLS_CONNECTION_ID_NODE_ID, null);
            }
        }
        if (this.maxTransmissionUnit > 0) {
            configBuilder.set((BasicDefinition)DtlsConfig.DTLS_MAX_TRANSMISSION_UNIT, (Object)this.maxTransmissionUnit);
        }
        if (this.maxFragmentLength > 0 && (length = TbCoapDtlsSettings.fromLength(this.maxFragmentLength)) != null) {
            configBuilder.set((BasicDefinition)DtlsConfig.DTLS_MAX_FRAGMENT_LENGTH, (Object)length);
        }
        configBuilder.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)new TbCoapDtlsCertificateVerifier(this.transportService, this.serviceInfoProvider, this.dtlsSessionInactivityTimeout, this.dtlsSessionReportTimeout, this.skipValidityCheckForClientCert));
        configBuilder.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(serverCredentials.getPrivateKey(), (Certificate[])serverCredentials.getCertificateChain(), Collections.singletonList(CertificateType.X_509)));
        return configBuilder.build();
    }

    private InetSocketAddress getInetSocketAddress() throws UnknownHostException {
        InetAddress addr = InetAddress.getByName(this.host);
        return new InetSocketAddress(addr, (int)this.port);
    }

    private static MaxFragmentLengthExtension.Length fromLength(int length) {
        for (MaxFragmentLengthExtension.Length l : MaxFragmentLengthExtension.Length.values()) {
            if (l.length() != length) continue;
            return l;
        }
        return null;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public int getDtlsRetransmissionTimeout() {
        return this.dtlsRetransmissionTimeout;
    }

    @Generated
    public Integer getCIdLength() {
        return this.cIdLength;
    }

    @Generated
    public Integer getMaxTransmissionUnit() {
        return this.maxTransmissionUnit;
    }

    @Generated
    public Integer getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    @Generated
    public SslCredentialsConfig getCoapDtlsCredentialsConfig() {
        return this.coapDtlsCredentialsConfig;
    }

    @Generated
    public boolean isSkipValidityCheckForClientCert() {
        return this.skipValidityCheckForClientCert;
    }

    @Generated
    public long getDtlsSessionInactivityTimeout() {
        return this.dtlsSessionInactivityTimeout;
    }

    @Generated
    public long getDtlsSessionReportTimeout() {
        return this.dtlsSessionReportTimeout;
    }

    @Generated
    public TransportService getTransportService() {
        return this.transportService;
    }

    @Generated
    public TbServiceInfoProvider getServiceInfoProvider() {
        return this.serviceInfoProvider;
    }
}

