/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.coapserver;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.coapserver.CoapServerContext;
import org.thingsboard.server.coapserver.CoapServerService;
import org.thingsboard.server.coapserver.TbCoapDtlsCertificateVerifier;
import org.thingsboard.server.coapserver.TbCoapDtlsSessionInfo;
import org.thingsboard.server.coapserver.TbCoapDtlsSessionKey;
import org.thingsboard.server.coapserver.TbCoapDtlsSettings;
import org.thingsboard.server.coapserver.TbCoapServerComponent;
import org.thingsboard.server.coapserver.TbCoapServerMessageDeliverer;

@Component
@TbCoapServerComponent
public class DefaultCoapServerService
implements CoapServerService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCoapServerService.class);
    @Autowired
    private CoapServerContext coapServerContext;
    private CoapServer server;
    private TbCoapDtlsCertificateVerifier tbDtlsCertificateVerifier;
    private ScheduledExecutorService dtlsSessionsExecutor;

    @PostConstruct
    public void init() throws UnknownHostException {
        this.createCoapServer();
    }

    @PreDestroy
    public void shutdown() {
        if (this.dtlsSessionsExecutor != null) {
            this.dtlsSessionsExecutor.shutdownNow();
        }
        log.info("Stopping CoAP server!");
        this.server.destroy();
        log.info("CoAP server stopped!");
    }

    @Override
    public CoapServer getCoapServer() throws UnknownHostException {
        if (this.server != null) {
            return this.server;
        }
        return this.createCoapServer();
    }

    @Override
    public ConcurrentMap<TbCoapDtlsSessionKey, TbCoapDtlsSessionInfo> getDtlsSessionsMap() {
        return this.tbDtlsCertificateVerifier != null ? this.tbDtlsCertificateVerifier.getTbCoapDtlsSessionsMap() : null;
    }

    @Override
    public synchronized Resource addResourceHierarchicallyAndReturnLast(List<String> resourceHierarchy) throws UnknownHostException {
        Resource childResource = null;
        CoapServer coapServer = this.getCoapServer();
        Resource root = coapServer.getRoot();
        for (String name : resourceHierarchy) {
            if (resourceHierarchy.get(0).equals(name)) {
                childResource = root.getChild(name);
                if (childResource != null) continue;
                childResource = new CoapResource(name);
                coapServer.add(new Resource[]{childResource});
                continue;
            }
            if (childResource == null) continue;
            Resource child = childResource.getChild(name);
            if (child == null) {
                child = new CoapResource(name);
                childResource.add(child);
                childResource = child;
                continue;
            }
            childResource = child;
        }
        return childResource;
    }

    private CoapServer createCoapServer() throws UnknownHostException {
        Configuration networkConfig = new Configuration();
        networkConfig.set((BasicDefinition)CoapConfig.BLOCKWISE_STRICT_BLOCK2_OPTION, (Object)true);
        networkConfig.set((BasicDefinition)CoapConfig.BLOCKWISE_ENTITY_TOO_LARGE_AUTO_FAILOVER, (Object)true);
        networkConfig.set(CoapConfig.BLOCKWISE_STATUS_LIFETIME, 300, TimeUnit.SECONDS);
        networkConfig.set((BasicDefinition)CoapConfig.MAX_RESOURCE_BODY_SIZE, (Object)0x10000000);
        networkConfig.set((BasicDefinition)CoapConfig.RESPONSE_MATCHING, (Object)CoapConfig.MatcherMode.RELAXED);
        networkConfig.set((BasicDefinition)CoapConfig.PREFERRED_BLOCK_SIZE, (Object)1024);
        networkConfig.set((BasicDefinition)CoapConfig.MAX_MESSAGE_SIZE, (Object)1024);
        networkConfig.set((BasicDefinition)CoapConfig.MAX_RETRANSMIT, (Object)4);
        networkConfig.set((BasicDefinition)CoapConfig.COAP_PORT, (Object)this.coapServerContext.getPort());
        this.server = new CoapServer(networkConfig, new int[0]);
        CoapEndpoint.Builder noSecCoapEndpointBuilder = new CoapEndpoint.Builder();
        InetAddress addr = InetAddress.getByName(this.coapServerContext.getHost());
        InetSocketAddress sockAddr = new InetSocketAddress(addr, (int)this.coapServerContext.getPort());
        noSecCoapEndpointBuilder.setInetSocketAddress(sockAddr);
        noSecCoapEndpointBuilder.setConfiguration(networkConfig);
        CoapEndpoint noSecCoapEndpoint = noSecCoapEndpointBuilder.build();
        this.server.addEndpoint((Endpoint)noSecCoapEndpoint);
        if (this.isDtlsEnabled()) {
            CoapEndpoint.Builder dtlsCoapEndpointBuilder = new CoapEndpoint.Builder();
            TbCoapDtlsSettings dtlsSettings = this.coapServerContext.getDtlsSettings();
            DtlsConnectorConfig dtlsConnectorConfig = dtlsSettings.dtlsConnectorConfig(networkConfig);
            networkConfig.set((BasicDefinition)CoapConfig.COAP_SECURE_PORT, (Object)dtlsConnectorConfig.getAddress().getPort());
            dtlsCoapEndpointBuilder.setConfiguration(networkConfig);
            DTLSConnector connector = new DTLSConnector(dtlsConnectorConfig);
            dtlsCoapEndpointBuilder.setConnector((Connector)connector);
            CoapEndpoint dtlsCoapEndpoint = dtlsCoapEndpointBuilder.build();
            this.server.addEndpoint((Endpoint)dtlsCoapEndpoint);
            this.tbDtlsCertificateVerifier = (TbCoapDtlsCertificateVerifier)dtlsConnectorConfig.getAdvancedCertificateVerifier();
            this.dtlsSessionsExecutor = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)this.getClass().getSimpleName());
            this.dtlsSessionsExecutor.scheduleAtFixedRate(this::evictTimeoutSessions, new Random().nextInt((int)this.getDtlsSessionReportTimeout()), this.getDtlsSessionReportTimeout(), TimeUnit.MILLISECONDS);
        }
        Resource root = this.server.getRoot();
        TbCoapServerMessageDeliverer messageDeliverer = new TbCoapServerMessageDeliverer(root);
        this.server.setMessageDeliverer((MessageDeliverer)messageDeliverer);
        this.server.start();
        return this.server;
    }

    @Override
    public boolean isDtlsEnabled() {
        return this.coapServerContext.getDtlsSettings() != null;
    }

    private void evictTimeoutSessions() {
        this.tbDtlsCertificateVerifier.evictTimeoutSessions();
    }

    private long getDtlsSessionReportTimeout() {
        return this.tbDtlsCertificateVerifier.getDtlsSessionReportTimeout();
    }
}

