/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.coapserver;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.coapserver.TbCoapDtlsSessionInfo;

public class TbCoapDtlsSessionInMemoryStorage {
    private static final Logger log = LoggerFactory.getLogger(TbCoapDtlsSessionInMemoryStorage.class);
    private final ConcurrentMap<InetSocketAddress, TbCoapDtlsSessionInfo> dtlsSessionsMap = new ConcurrentHashMap<InetSocketAddress, TbCoapDtlsSessionInfo>();
    private long dtlsSessionInactivityTimeout;
    private long dtlsSessionReportTimeout;

    public TbCoapDtlsSessionInMemoryStorage(long dtlsSessionInactivityTimeout, long dtlsSessionReportTimeout) {
        this.dtlsSessionInactivityTimeout = dtlsSessionInactivityTimeout;
        this.dtlsSessionReportTimeout = dtlsSessionReportTimeout;
    }

    public void put(InetSocketAddress remotePeer, TbCoapDtlsSessionInfo dtlsSessionInfo) {
        log.trace("DTLS session added to in-memory store: [{}] timestamp: [{}]", (Object)remotePeer, (Object)dtlsSessionInfo.getLastActivityTime());
        this.dtlsSessionsMap.putIfAbsent(remotePeer, dtlsSessionInfo);
    }

    public void evictTimeoutSessions() {
        long expTime = System.currentTimeMillis() - this.dtlsSessionInactivityTimeout;
        this.dtlsSessionsMap.entrySet().removeIf(entry -> {
            if (((TbCoapDtlsSessionInfo)entry.getValue()).getLastActivityTime() < expTime) {
                log.trace("DTLS session was removed from in-memory store: [{}]", entry.getKey());
                return true;
            }
            return false;
        });
    }

    public ConcurrentMap<InetSocketAddress, TbCoapDtlsSessionInfo> getDtlsSessionsMap() {
        return this.dtlsSessionsMap;
    }

    public long getDtlsSessionInactivityTimeout() {
        return this.dtlsSessionInactivityTimeout;
    }

    public long getDtlsSessionReportTimeout() {
        return this.dtlsSessionReportTimeout;
    }

    public void setDtlsSessionInactivityTimeout(long dtlsSessionInactivityTimeout) {
        this.dtlsSessionInactivityTimeout = dtlsSessionInactivityTimeout;
    }

    public void setDtlsSessionReportTimeout(long dtlsSessionReportTimeout) {
        this.dtlsSessionReportTimeout = dtlsSessionReportTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbCoapDtlsSessionInMemoryStorage)) {
            return false;
        }
        TbCoapDtlsSessionInMemoryStorage other = (TbCoapDtlsSessionInMemoryStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDtlsSessionInactivityTimeout() != other.getDtlsSessionInactivityTimeout()) {
            return false;
        }
        if (this.getDtlsSessionReportTimeout() != other.getDtlsSessionReportTimeout()) {
            return false;
        }
        ConcurrentMap<InetSocketAddress, TbCoapDtlsSessionInfo> this$dtlsSessionsMap = this.getDtlsSessionsMap();
        ConcurrentMap<InetSocketAddress, TbCoapDtlsSessionInfo> other$dtlsSessionsMap = other.getDtlsSessionsMap();
        return !(this$dtlsSessionsMap == null ? other$dtlsSessionsMap != null : !this$dtlsSessionsMap.equals(other$dtlsSessionsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbCoapDtlsSessionInMemoryStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $dtlsSessionInactivityTimeout = this.getDtlsSessionInactivityTimeout();
        result = result * 59 + (int)($dtlsSessionInactivityTimeout >>> 32 ^ $dtlsSessionInactivityTimeout);
        long $dtlsSessionReportTimeout = this.getDtlsSessionReportTimeout();
        result = result * 59 + (int)($dtlsSessionReportTimeout >>> 32 ^ $dtlsSessionReportTimeout);
        ConcurrentMap<InetSocketAddress, TbCoapDtlsSessionInfo> $dtlsSessionsMap = this.getDtlsSessionsMap();
        result = result * 59 + ($dtlsSessionsMap == null ? 43 : $dtlsSessionsMap.hashCode());
        return result;
    }

    public String toString() {
        return "TbCoapDtlsSessionInMemoryStorage(dtlsSessionsMap=" + String.valueOf(this.getDtlsSessionsMap()) + ", dtlsSessionInactivityTimeout=" + this.getDtlsSessionInactivityTimeout() + ", dtlsSessionReportTimeout=" + this.getDtlsSessionReportTimeout() + ")";
    }
}

